import Panel from "../views/Panel";
import Tween = egret.Tween;
import Image = eui.Image;
import {NetManager} from "../../libs/tw/manager/NetManager";
import {GetProfitDetailData} from "../../libs/tw/data/customMade/GetProfitDetailData";
import {GDispatcher} from "../../libs/tc/util/GDispatcher";
import {Tools} from "../Tools";
import {MainIns} from "../Scenes/MainScene/MainScene";
import {getlogItem} from "../comm/getlogItem";

export default class GameGroupPanel extends Panel {
    public closeBtn: Image;
    public planeBtn: Image;
    public clearBtn: Image;

    public get skinKey() {
        return 'GameGroup'
    }

    public get groupName() {
        return 'gameGroup_panel'
    }

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        Tween.get(this).set({y: canvasH}).to({y: canvasH - this.height}, 300, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts()
            .concat([
                [this.planeBtn, this.onTap, this],
                [this.clearBtn, this.onTap, this],
            ]);
    }

    private onTap(e) {
        let k = 'dxq';
        switch (e.target) {
            case this.planeBtn:
                NetManager.ins.clickLog(getlogItem(16));
                k = 'dxq';
                break;

            case this.clearBtn:
                NetManager.ins.clickLog(getlogItem(17));
                k = 'xxl';
                break;
        }

        NetManager.ins.gameGroupMark(() => {
            GDispatcher.addEvent('docVisible', this.back, this);
            window.location.href = window['gameGroupLink'][k];
        }, k);
    }

    async back() {
        GDispatcher.removeEvent('docVisible', this.back, this);
        await Tools.gameGroupPrize();
        MainIns().mainUI.getPropInfo();
    }

    protected start() {
        super.start();

        this.initUI();
    }

    private initUI(): void {
        NetManager.ins.showLog(getlogItem(16));
        NetManager.ins.showLog(getlogItem(17));
    }

    destroy() {
        super.destroy();
    }

}
