import { Data } from "../Data";

/**
 * 宠物喂食
 */
export class PetFeedData extends Data {
    /**
     * 错误标识码（见状态码-宠物养成-喂食错误码）
     */
    public errorCode: string;

    /**
     * 当前状态（1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉）
     */
    public status: number;

    /**
     * 拥有萝卜数量
     */
    public foodNum: number;

    /**
     * 状态剩余时间
     */
    public leftMinutes: number;

    /**
     * 喂食周期剩余时间（分钟）
     */
    public feedIntervalRemain: number;

    /**
     * 是否升级
     */
    public isLevelUp:boolean;

    /**
     * 升级插件id
     */
    public levelPluginId:boolean;


    public update(result: any): void {
        if (!result) {
            return;
        }
        result.message = result.message ;//window['errorMessage'] ? window['errorMessage'][result.errorCode] : "";
        super.update(result);
        this.errorCode = result.errorCode;
        if (result.data) {
            this.status = result.data.status;
            this.foodNum = result.data.foodNum;
            this.isLevelUp = result.data.isLevelUp;
            this.levelPluginId = result.data.levelPluginId;
            this.leftMinutes = result.data.leftMinutes;
            this.feedIntervalRemain = result.data.feedIntervalRemain;
        }
    }
}