"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var ComponentBase_1 = require("../components/ComponentBase");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel(data) {
        return _super.call(this, data) || this;
    }
    Panel.prototype.onShowAnim = function () {
        var _this = this;
        egret.Tween.get(this)
            .set({ visible: true, alpha: 0, y: -200 })
            .to({ alpha: 1, y: 0 }, 500, egret.Ease.quartOut)
            .call(function () { return _this.onShowAnimCall(); });
    };
    Panel.prototype.onShowAnimCall = function () {
    };
    Panel.prototype.onHide = function () {
        return this.hideAnim().call(this.onHideAnimCall.bind(this));
    };
    Panel.prototype.hideAnim = function () {
        return egret.Tween.get(this)
            .to({ y: 750 / window.innerWidth * window.innerHeight }, 300, egret.Ease.quartIn);
    };
    Panel.prototype.onHideAnimCall = function () {
    };
    Panel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this);
    };
    Panel.prototype.getBeginEvts = function () {
        return _super.prototype.getBeginEvts.call(this);
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) {
                if (btn)
                    btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchClose, _this);
            });
        }
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        _super.prototype.removeEvents.call(this);
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) {
                if (btn)
                    btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchClose, _this);
            });
        }
    };
    Panel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        Loading_1.default.instace.hide();
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () {
            return [this['closeBtn']];
        },
        enumerable: true,
        configurable: true
    });
    Panel.prototype.onTouchClose = function () {
        this.hidePanel();
    };
    Panel.prototype.hidePanel = function () {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    };
    return Panel;
}(ComponentBase_1.default));
exports.default = Panel;
__reflect(Panel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/views/Panel\".Panel");
//# sourceMappingURL=Panel.js.map