"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var panelCtrl_1 = require("./panelCtrl");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////// Public Method //////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (type, data) {
        if (this._currentScene) {
            this._currentScene.destroy();
            this._parent.removeChild(this._currentScene);
        }
        egret.Tween.removeAllTweens();
        panelCtrl_1.default.instance.removeCurrent();
        Loading_1.default.instace.show();
        var cls = this._sceneClassMap[type];
        var scene = new cls(data);
        // scene.setSkinName();
        // scene.start();
        this.addToStage(scene);
    };
    SceneCtrl.prototype.registerScenes = function (scenes) {
        var _this = this;
        scenes.forEach(function (v) { return _this.registerSceneClass(v[0], v[1]); });
    };
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////// Private Method //////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    SceneCtrl.prototype.registerSceneClass = function (name, definition) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = definition;
    };
    SceneCtrl.prototype.addToStage = function (scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;
__reflect(SceneCtrl.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/ctrls/sceneCtrl\".SceneCtrl");
//# sourceMappingURL=sceneCtrl.js.map