"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
var Main_1 = require("../Main");
var MainScene_1 = require("../Scenes/MainScene/MainScene");
var ProgressNum = (function (_super) {
    __extends(ProgressNum, _super);
    function ProgressNum(data) {
        var _this = _super.call(this) || this;
        _this.canMove = false;
        _this.data = null;
        _this.total = 0; // 总个数
        _this.number = 1; // 当前个数
        _this.skinName = utils_1.getSkinPath('Component/ProgressNum');
        _this.data = data || null;
        _this.total = _this.data.total;
        // this.numLabel.text = `${this.number}`;
        _this.setHandX(0);
        _this.initEvents();
        _this.hand.anchorOffsetX = 19;
        return _this;
    }
    Object.defineProperty(ProgressNum.prototype, "value", {
        get: function () {
            return this.number;
        },
        enumerable: true,
        configurable: true
    });
    ProgressNum.prototype.initEvents = function () {
        Main_1.MainStage.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.groupTouchBegin, this);
        Main_1.MainStage.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.groupTouchMEC, this);
        Main_1.MainStage.addEventListener(egret.TouchEvent.TOUCH_END, this.groupTouchMEC, this);
        Main_1.MainStage.addEventListener(egret.TouchEvent.TOUCH_CANCEL, this.groupTouchMEC, this);
    };
    ProgressNum.prototype.setHandX = function (x) {
        var aWidth = this.bar.width / (this.total - 1);
        if (aWidth == Infinity) {
            aWidth = this.bar.width + 10; /// TODO +10 保证total为1是显示正常 临时方案
        }
        var dx = x % aWidth; // 取余数
        x = (~~(x / aWidth) + (dx >= (aWidth / 2) ? 1 : 0)) * aWidth; // 过半吸附
        this.hand.x = x;
        if (this.hand.x < 0) {
            this.hand.x = 0;
        }
        else if (this.hand.x > this.bar.width) {
            this.hand.x = this.bar.width;
        }
        this.fill.width = this.hand.x;
        this.number = ~~(this.hand.x / aWidth) + 1; // * (this.total) + 1);
        this.setNumber();
        MainScene_1.MainDispatcher.dispatchEvent('updateSellValue');
    };
    ProgressNum.prototype.setNumber = function () {
        if (this.total == 0) {
            this.number = 0;
        }
        this.numLabel.text = "" + this.number;
    };
    ProgressNum.prototype.groupTouchBegin = function (e) {
        this.canMove = this.touchGroup.hitTestPoint(e.stageX, e.stageY);
        if (this.canMove) {
            this.setHandX(e.stageX - this.x);
        }
    };
    ProgressNum.prototype.groupTouchMEC = function (e) {
        if (!this.canMove) {
            return;
        }
        this.setHandX(e.stageX - this.x);
    };
    ProgressNum.prototype.destroy = function () {
        Main_1.MainStage.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.groupTouchBegin, this);
        Main_1.MainStage.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.groupTouchMEC, this);
        Main_1.MainStage.removeEventListener(egret.TouchEvent.TOUCH_END, this.groupTouchMEC, this);
        Main_1.MainStage.removeEventListener(egret.TouchEvent.TOUCH_CANCEL, this.groupTouchMEC, this);
    };
    return ProgressNum;
}(eui.Component));
exports.ProgressNum = ProgressNum;
__reflect(ProgressNum.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/components/ProgressNum\".ProgressNum");
//# sourceMappingURL=ProgressNum.js.map