"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
exports.showToast = function (msg) {
    topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: msg });
};
exports.btnDelay = function (targe, dtime) {
    if (dtime === void 0) { dtime = 500; }
    targe.touchEnabled = false;
    setTimeout(function () {
        targe.touchEnabled = true;
    }, dtime);
};
/**
 * 获取我的奖品链接
 */
exports.gotoRecord = function () {
    var recordUrl;
    var oaId;
    if (DataManager_1.DataManager.ins.customCfgData) {
        oaId = DataManager_1.DataManager.ins.customCfgData.oaId;
        recordUrl = DataManager_1.DataManager.ins.customCfgData.recordUrl;
    }
    else {
        oaId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        recordUrl = window['recordUrl'];
    }
    if (recordUrl.indexOf('?') != -1) {
        recordUrl += '&origins=' + oaId + '00';
    }
    else {
        recordUrl += '?origins=' + oaId + '00';
    }
    return recordUrl;
};
/**
 * 获取连接上的参数，以对象的形式返回
 */
exports.getRequest = function () {
    var url = location.search; //获取url中"?"符后的字串
    var theRequest = {};
    if (url.indexOf("?") != -1) {
        var str = url.substr(1);
        var strs = str.split("&");
        for (var i = 0; i < strs.length; i++) {
            theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
        }
    }
    return theRequest;
};
/**
 * 通过Key获取连接上的参数
 * @param key
 */
exports.getRequestByKey = function (key) {
    return this.getRequest()[key];
};
/**
 * 时间戳转几时几分几秒
 * @param time 时间戳
 */
exports.convertTime = function (time) {
    var hour = ~~(time / 3600000); // 小时
    var min = ~~((time - hour * 3600000) / 60000); // 分
    var sec = ~~((time - hour * 3600000 - min * 60000) / 1000); // 秒
    return {
        hour: exports.prefixInteger(hour, 2),
        min: exports.prefixInteger(min, 2),
        sec: exports.prefixInteger(sec, 2)
    };
};
/**
 * 数字补0
 * @param num 数字
 * @param length 位数
 */
exports.prefixInteger = function (num, length) {
    return (Array(length).join('0') + num).slice(-length);
};
/**
 * 对象/数组 深拷贝
 * @param {Object} src - 来源对象
 * @param {Object} dst - 目标对象
 * @returns {Object} obj - 拷贝完成的对象
 */
exports.deepClone = function (src, dst) {
    if (dst === void 0) { dst = undefined; }
    if (!(src instanceof Object) && !(src instanceof Array)) {
        return src;
    }
    var _obj = dst || src instanceof Array ? [] : {};
    for (var key in src) {
        var prop = src[key];
        if (prop === _obj) {
            continue;
        }
        _obj[key] = ((typeof prop === 'object') ? exports.deepClone(prop) : _obj[key] = prop);
    }
    return _obj;
};
/**
 * 产生一个固定范围的随机数(左闭右开)
 * @param start
 * @param end
 */
exports.Random = function (start, end) {
    return Math.random() * (end - start) + start;
};
/**
 * 产生一个固定范围的随机整数(左闭右开)
 * @param start
 * @param end
 */
exports.RandomInt = function (start, end) {
    return ~~(Math.random() * (end - start) + start);
};
/**
 * obj是否在array中
 * @param obj
 * @param array
 */
exports.isInArray = function (obj, array) {
    for (var i in array) {
        if (obj == array[i]) {
            return true;
        }
    }
    return false;
};
/**
 * 简单的碰撞检测
 * @param obj1
 * @param obj2
 */
exports.hitTest = function (obj1, obj2) {
    var rect1 = obj1.getBounds();
    var rect2 = obj2.getBounds();
    rect1.x = obj1.x;
    rect1.y = obj1.y;
    rect2.x = obj2.x;
    rect2.y = obj2.y;
    return rect1.intersects(rect2);
};
//# sourceMappingURL=UtilsConst.js.map