"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 局部的事件收发器
 */
var Dispatcher = (function () {
    function Dispatcher() {
        /**
         * 事件回调池
         */
        this.callbackPool = {};
        /**
         * 事件作用域池
         */
        this.thisObjPool = {};
    }
    /**
     *
     * @param name 事件名
     * @param callback 回调
     * @param thisObj 作用域
     */
    Dispatcher.prototype.addEvent = function (name, callback, thisObj) {
        if (!this.callbackPool[name]) {
            this.callbackPool[name] = [];
            this.thisObjPool[name] = [];
        }
        var index = this.callbackPool[name].indexOf(callback);
        var thisObjIndex = this.thisObjPool[name].indexOf(thisObj);
        if (index != -1 && thisObjIndex != -1) {
            this.callbackPool[name][index] = callback;
            this.thisObjPool[name][index] = thisObj;
        }
        else {
            this.callbackPool[name].push(callback);
            this.thisObjPool[name].push(thisObj);
        }
    };
    /**
     *
     * @param name 事件名
     * @param callback 回调
     * @param thisObj 作用域
     */
    Dispatcher.prototype.removeEvent = function (name, callback, thisObj) {
        if (this.callbackPool[name]) {
            var index = this.callbackPool[name].indexOf(callback);
            if (index != -1) {
                this.callbackPool[name].splice(index, 1);
                this.thisObjPool[name].splice(index, 1);
            }
        }
    };
    /**
     * 派发事件
     * @param name 事件名
     * @param args 任意参数
     */
    Dispatcher.prototype.dispatchEvent = function (name) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var callbacks = this.callbackPool[name];
        var thisObjs = this.thisObjPool[name];
        if (callbacks) {
            var i = 0;
            var len = callbacks.length;
            for (i; i < len; i++) {
                callbacks[i].apply(thisObjs[i], args);
            }
        }
    };
    return Dispatcher;
}());
exports.default = Dispatcher;
__reflect(Dispatcher.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/comm/Dispatcher\".Dispatcher");
//# sourceMappingURL=Dispatcher.js.map