"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var HtmlTextParser_1 = require("../../libs/tc/util/HtmlTextParser");
/**
 * 简单的倒计时
 * Created on 2019/10/24
 */
var CutTimer = (function () {
    /**
     * @param label 传入显示的label
     * @param labelText 该字符串将作为倒计时显示的文字，hh、mm、ss将被分别替换成时，分，秒，例：将在hh:mm:ss后消失 -> 将在18:07:21后消失
     * @param callFun 如果希望他在结束时去做一些什么则传入一个回调函数
     */
    function CutTimer(label, labelText, callFun) {
        this._timer = null;
        this._label = null;
        this._labelText = "hh:mm:ss";
        // 倒计时时间
        this._cutTime = 0;
        // 回调函数
        this._callFun = null;
        this._label = label || null;
        this._labelText = labelText || "hh:mm:ss";
        this._callFun = callFun || null;
    }
    Object.defineProperty(CutTimer.prototype, "labelText", {
        set: function (labelText) {
            this._labelText = labelText;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CutTimer.prototype, "cutTime", {
        set: function (cutTime) {
            this._cutTime = cutTime;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CutTimer.prototype, "callFun", {
        set: function (callFun) {
            this._callFun = callFun;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 根据时间开始倒计时
     * 1.假如已经存在一个倒计时返回false（失败），表示要先执行stop或stopAndCallFun
     * 2.保存倒计时时间 +1秒弥补第5步操作
     * 3.创建一个倒计时对象
     * 4.注册时间监听
     * 5.立即执行一次倒计时（为了立即刷新label）
     * 6.开始倒计时
     * 7.返回true（成功）
     * @param cutTime 时间戳
     */
    CutTimer.prototype.start = function (cutTime) {
        if (this._timer) {
            return false;
        }
        this._cutTime = cutTime + 1000; // +1秒弥补立即刷新
        this._timer = new egret.Timer(1000, 0);
        this._timer.addEventListener(egret.TimerEvent.TIMER, this._cutTimer, this);
        this._cutTimer();
        this._timer.start();
        return true;
    };
    /**
     * 结束计时器，不执行回调函数
     * 1.停止计时器
     * 2.移除事件监听
     * 3.置空计时器
     * 4.如果希望执行回调函数请使用stopAndCallFun()
     */
    CutTimer.prototype.stop = function () {
        if (!this._timer) {
            return;
        }
        this._timer.stop();
        this._timer.removeEventListener(egret.TimerEvent.TIMER, this._cutTimer, this);
        this._timer = null;
    };
    /**
     * 结束倒数计时并执行回调函数
     * 1.停止计时器
     * 2.移除事件监听
     * 3.置空计时器
     * 4.执行回调函数函数，如果不希望执行回调函数则使用stop()
     */
    CutTimer.prototype.stopAndCallFun = function () {
        if (!this._timer) {
            return;
        }
        this._timer.stop();
        this._timer.removeEventListener(egret.TimerEvent.TIMER, this._cutTimer, this);
        this._timer = null;
        if (this._callFun) {
            this._callFun();
        }
    };
    /**
     * 倒计时回调函数
     * @private
     */
    CutTimer.prototype._cutTimer = function () {
        var timer = this._convertTime(this._cutTime -= 1000);
        if (timer.hour === "00"
            && timer.min === "00"
            && timer.sec === "00") {
            this.stopAndCallFun();
        }
        if (!this._label) {
            return;
        }
        var str = this._labelText;
        str = str.replace(/hh/g, timer.hour);
        str = str.replace(/mm/g, timer.min);
        str = str.replace(/ss/g, timer.sec);
        if (this._label instanceof eui.Label) {
            this._label.textFlow = (new HtmlTextParser_1.HtmlTextParser).parser(str);
        }
        else {
            this._label.text = str;
        }
    };
    /**
     * 通过时间戳获取几时积分几秒    例：666666666 -> {hour: 18, min: 51, sec: 16}
     * @param time 时间戳（毫秒）
     * @private
     */
    CutTimer.prototype._convertTime = function (time) {
        var hour = ~~(time / 3600000); // 小时
        var min = ~~((time - hour * 3600000) / 60000); // 分
        var sec = ~~((time - hour * 3600000 - min * 60000) / 1000); // 秒
        return {
            hour: this._prefixInteger(hour, 2),
            min: this._prefixInteger(min, 2),
            sec: this._prefixInteger(sec, 2)
        };
    };
    /**
     * 数字补0 例：(num = 2, length = 2) -> 02
     * @param num 数字
     * @param length 位数
     * @private
     */
    CutTimer.prototype._prefixInteger = function (num, length) {
        return (Array(length).join('0') + num).slice(-length);
    };
    return CutTimer;
}());
exports.default = CutTimer;
__reflect(CutTimer.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/comm/CutTimer\".CutTimer");
//# sourceMappingURL=CutTimer.js.map