"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../utils");
var MainScene_1 = require("./MainScene");
var LandMgr_1 = require("./LandMgr");
var OptionPanel_1 = require("./Objs/OptionPanel");
var TimeProgressBar = (function (_super) {
    __extends(TimeProgressBar, _super);
    function TimeProgressBar(index, title, label, startTime, nowTime, endTime) {
        var _this = _super.call(this) || this;
        _this.labelText = '';
        _this.progressText = '';
        _this._timer = null;
        _this.skinName = utils_1.getSkinPath('Component/TimeProgressBar');
        _this.labelText = title;
        _this.startTime = startTime;
        _this.nowTime = nowTime;
        _this.endTime = endTime;
        _this.progressText = 'hh时mm分后' + label;
        _this.initUI();
        _this.addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
            OptionPanel_1.M_HideOption();
        }, _this);
        return _this;
    }
    TimeProgressBar.prototype.addSpeed = function (callFun) {
        this._timer.stop();
        this.nowTime -= 4 * 60 * 60;
        if (this.nowTime < 0) {
            this.nowTime = 0;
        }
        var timer = this._convertTime(this.nowTime);
        var str = this.progressText;
        str = str.replace(/hh/g, timer.hour);
        str = str.replace(/mm/g, timer.min);
        str = str.replace(/ss/g, timer.sec);
        this.progressLabel.text = str;
        var progress = (this.nowTime - this.startTime) / (this.endTime - this.startTime);
        if (progress > 100) {
            progress = 100;
        }
        var _width = this.progressBar.width * progress;
        egret.Tween.get(this.progressFill)
            .to({ width: _width }, 1000)
            .wait(1000)
            .call(callFun);
    };
    TimeProgressBar.prototype.initUI = function () {
        this.progressFill.mask = this.fillMask;
        this.corpName.text = this.labelText;
        this.setProgress();
        this.cTime = this.nowTime + 4;
        this.cutFun();
        this._timer = new egret.Timer(1000, this.cTime);
        this._timer.addEventListener(egret.TimerEvent.TIMER, this.cutFun, this);
        this._timer.start();
    };
    TimeProgressBar.prototype.cutFun = function () {
        this.cTime -= 1;
        var timer = this._convertTime(this.cTime + 60);
        this.nowTime += 1;
        // console.log(this.cTime);
        if (this.cTime <= 0) {
            this.stop();
        }
        var str = this.progressText;
        str = str.replace(/hh/g, timer.hour);
        str = str.replace(/mm/g, timer.min);
        str = str.replace(/ss/g, timer.sec);
        this.progressLabel.text = str;
        this.setProgress();
    };
    TimeProgressBar.prototype.stop = function () {
        console.log('stop');
        this._timer && this._timer.stop();
        MainScene_1.M_CanUpdate() && LandMgr_1.M_UpdateLand();
    };
    TimeProgressBar.prototype.destroy = function () {
        if (this._timer) {
            this._timer.stop();
            this._timer = null;
        }
    };
    /**
     * 设置进度
     */
    TimeProgressBar.prototype.setProgress = function () {
        var progress = (this.nowTime - this.startTime) / (this.endTime - this.startTime);
        if (progress > 100) {
            progress = 100;
        }
        else if (progress < 0) {
            progress = 0;
        }
        this.progressFill.width = this.progressBar.width * progress;
    };
    /**
     * 通过时间戳获取几时积分几秒
     * @param time 时间戳（毫秒）
     * @private
     */
    TimeProgressBar.prototype._convertTime = function (time) {
        var hour = ~~(time / 3600); // 小时
        var min = ~~((time - hour * 3600) / 60); // 分
        var sec = ~~((time - hour * 3600 - min * 60)); // 秒
        return {
            hour: this._prefixInteger(hour, 2),
            min: this._prefixInteger(min, 2),
            sec: this._prefixInteger(sec, 2)
        };
    };
    /**
     * 数字补0 例：(num = 2, length = 2) -> 02
     * @param num 数字
     * @param length 位数
     * @private
     */
    TimeProgressBar.prototype._prefixInteger = function (num, length) {
        return (Array(length).join('0') + num).slice(-length);
    };
    return TimeProgressBar;
}(eui.Component));
exports.default = TimeProgressBar;
__reflect(TimeProgressBar.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/TimeProgressBar\".TimeProgressBar");
//# sourceMappingURL=TimeProgressBar.js.map