"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils");
var Crop_1 = require("./Crop");
var NetManager_1 = require("../../../../libs/tw/manager/NetManager");
var getlogItem_1 = require("../../../comm/getlogItem");
var OptionPanel_1 = require("./OptionPanel");
var LAND_STATE;
(function (LAND_STATE) {
    LAND_STATE["NONE"] = "none";
    LAND_STATE["ACTIVE"] = "active";
    LAND_STATE["PLANT"] = "plant";
    LAND_STATE["ANIMAL"] = "animal"; // 动物
})(LAND_STATE || (LAND_STATE = {}));
/**
 * 土地类
 */
var Land = (function (_super) {
    __extends(Land, _super);
    function Land(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.skinName = utils_1.getSkinPath('Objs/Land');
        _this.data = data || null;
        _this.index = data.index;
        _this.x = data.x;
        _this.y = data.y;
        _this.initEvents(); // 注册事件
        _this.changeState(LAND_STATE.NONE);
        _this.initUI(); // 设置显示
        return _this;
    }
    /**
     * 取消active状态
     */
    Land.prototype.reActive = function () {
        this.state == LAND_STATE.ACTIVE && this.changeState(LAND_STATE.NONE);
    };
    Land.prototype.plant = function (data) {
        this.crop.plant(data);
    };
    Land.prototype.updateData = function (data) {
        this.data = data;
        this.changeState(LAND_STATE.NONE);
        var landData = this.data.data;
        /// TODO 根据数据添加Crop 初始化状态
        if (landData.petId) {
            if (landData.petId == 1 || landData.petId == 4) {
                this.changeState(LAND_STATE.ANIMAL);
            }
            else {
                this.changeState(LAND_STATE.PLANT);
            }
        }
        else {
            this.changeState(LAND_STATE.NONE);
        }
        this.crop && this.crop.updateDate(this.data);
    };
    Land.prototype.destroy = function () {
        this.land.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.crop && this.crop.destroy();
        this.crop = null;
    };
    /**
     * 设置点击参数
     */
    Land.prototype.setTouchOption = function () {
        this.touchEnabled = false; // 保证空白处不可点击，且子对象可点击
        this.touchChildren = true;
        this.land.touchEnabled = true;
        this.land.pixelHitTest = true; // 保证透明像素不可点击
        this.fence.touchEnabled = false; // 保证栅栏和食槽不可点击
        this.trough.touchEnabled = false;
    };
    Land.prototype.initEvents = function () {
        this.land.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    Land.prototype.onTap = function () {
        console.log("\u70B9\u51FB\u4E86\u7B2C" + this.index + "\u5757\u571F\u5730, \u5F53\u524D\u72B6\u6001\u662F" + this.state);
        if (this.state != LAND_STATE.NONE) {
            // M_HideOption();
            return;
        }
        // 显示Option
        NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(this.index + 7)); // 8, 9, 10, 11
        OptionPanel_1.M_ShowOption({ index: this.index, pos: { x: this.x, y: this.y } });
        this.changeState(LAND_STATE.ACTIVE);
    };
    Land.prototype.initUI = function () {
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(this.index + 7)); // 8, 9, 10, 11
        this.setTouchOption(); // 设置点击参数
        var landData = this.data.data;
        /// TODO 根据数据添加Crop 初始化状态
        if (landData.petId) {
            if (landData.petId == 1 || landData.petId == 4) {
                this.changeState(LAND_STATE.ANIMAL);
            }
            else {
                this.changeState(LAND_STATE.PLANT);
            }
        }
        else {
            this.changeState(LAND_STATE.NONE);
        }
        this.crop = new Crop_1.default(this.data);
        this.addChildAt(this.crop, 2);
        this.crop.y = 75;
    };
    // 改变状态积
    Land.prototype.changeState = function (state) {
        if (state == this.state) {
            return;
        }
        this.state = state; // 设置状态
        this.land.source = "plant_land_" + this.state + "_png"; // 设置图片
        this.fence.visible = (this.state == LAND_STATE.ANIMAL); // 显示栅栏
        this.trough.visible = (this.state == LAND_STATE.ANIMAL); // 显示食槽
        /// TODO 定义状态积详情
        switch (this.state) {
            case LAND_STATE.NONE:// 啥也没有
                break;
            case LAND_STATE.ACTIVE:// 点击
                break;
            case LAND_STATE.PLANT:// 植物
                break;
            case LAND_STATE.ANIMAL:// 动物
                break;
            default:
                break;
        }
    };
    return Land;
}(eui.Component));
exports.default = Land;
__reflect(Land.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/Objs/Land\".Land");
//# sourceMappingURL=Land.js.map