"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils");
var MainScene_1 = require("../MainScene");
var loadSvga_1 = require("../../../comm/loadSvga");
var NetManager_1 = require("../../../../libs/tw/manager/NetManager");
var UtilsConst_1 = require("../../../comm/UtilsConst");
var OptionPanel_1 = require("./OptionPanel");
var LandMgr_1 = require("../LandMgr");
var Home_1 = require("../../Home");
var CROP_TYPE;
(function (CROP_TYPE) {
    CROP_TYPE[CROP_TYPE["NONE"] = 0] = "NONE";
    CROP_TYPE[CROP_TYPE["CHICKEN"] = 1] = "CHICKEN";
    CROP_TYPE[CROP_TYPE["WHEAT"] = 2] = "WHEAT";
    CROP_TYPE[CROP_TYPE["CORN"] = 3] = "CORN";
    CROP_TYPE[CROP_TYPE["CATTLE"] = 4] = "CATTLE";
})(CROP_TYPE || (CROP_TYPE = {}));
var petData = {
    0: {
        key: '',
        name: '',
        type: '',
        pos: [],
        propId: '',
        optionSvga: '',
        option: '',
        catherImg: ''
    },
    1: {
        key: 'chicken',
        name: '鸡',
        type: 'animal',
        pos: [-65, -162],
        propId: 'sp_food_1',
        optionSvga: 'ready_feed',
        option: 'feed',
        catherImg: '鸡蛋'
    },
    2: {
        key: 'wheat',
        name: '小麦',
        type: 'plant',
        pos: [-65, -140],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '麦粉'
    },
    3: {
        key: 'corn',
        name: '玉米',
        type: 'plant',
        pos: [-65, -140],
        catherPos: [-65, -180],
        propId: 'sp_food_2',
        optionSvga: 'ready_water',
        option: 'water',
        catherImg: '玉米',
    },
    4: {
        key: 'cattle',
        name: '牛',
        type: 'animal',
        pos: [-70, -145],
        prop: 'food',
        propId: 'sp_food_1',
        optionSvga: 'ready_feed',
        option: 'feed',
        catherImg: '牛奶',
    },
};
var CROP_STATE;
(function (CROP_STATE) {
    CROP_STATE[CROP_STATE["NONE"] = 0] = "NONE";
    CROP_STATE[CROP_STATE["LEVEL1"] = 1] = "LEVEL1";
    CROP_STATE[CROP_STATE["LEVEL2"] = 2] = "LEVEL2";
    CROP_STATE[CROP_STATE["LEVEL3"] = 3] = "LEVEL3";
    CROP_STATE[CROP_STATE["LEVEL4"] = 4] = "LEVEL4";
})(CROP_STATE || (CROP_STATE = {}));
var OPTION;
(function (OPTION) {
    OPTION[OPTION["NONE"] = 0] = "NONE";
    OPTION[OPTION["GATHER"] = 1] = "GATHER";
    OPTION[OPTION["FEED"] = 2] = "FEED";
    OPTION[OPTION["PROGRESS"] = 3] = "PROGRESS";
})(OPTION || (OPTION = {}));
var CROP_X = 53.5;
var CROP_Y = -18;
/**
 * 作物类
 */
var Crop = (function (_super) {
    __extends(Crop, _super);
    function Crop(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.changeMv = false;
        _this.lastG = false;
        _this.showP = false;
        _this.skinName = utils_1.getSkinPath('Objs/Crop');
        _this.data = data || null;
        _this.index = _this.data.index;
        _this.x = CROP_X;
        _this.y = CROP_Y;
        _this.changePetId(CROP_TYPE.NONE);
        _this.changeState(CROP_STATE.NONE);
        _this.initUI();
        return _this;
    }
    Crop.prototype.reset = function () {
        this.progressBar && egret.Tween.removeTweens(this.progressBar);
        MainScene_1.MainIns().progressMgr.removeProgress(this.data.index);
        this.progressBar = null;
        this.speedMv && this.removeChild(this.speedMv) && (this.speedMv = null);
    };
    Crop.prototype.plant = function (data) {
        var _this = this;
        MainScene_1.M_SetGameLayerUpdate(false);
        loadSvga_1.loadSvga(utils_1.getSvga(petData[data.petId].key + "_plant")).then(function (mv) {
            mv.x = 82;
            mv.y = -40;
            _this.addChild(mv);
            mv.addEventListener(egret.Event.COMPLETE, function () {
                mv.stop();
                _this.removeChild(mv);
                MainScene_1.M_SetGameLayerUpdate(true);
                LandMgr_1.M_UpdateLand();
            }, _this);
        });
    };
    Crop.prototype.updateDate = function (data) {
        this.data = data;
        this.reset();
        this.initUI();
    };
    Crop.prototype.destroy = function () {
        this.cropMv && function () {
            egret.Tween.removeTweens(this.cropMv);
            this.removeChild(this.cropMv);
            this.cropMv = null;
        }.bind(this)();
        this.optionMv && function () {
            egret.Tween.removeTweens(this.optionMv);
            this.group.removeChild(this.optionMv);
            this.optionMv = null;
        }.bind(this)();
        this.progressBar && function () {
            egret.Tween.removeTweens(this.progressBar);
            this.progressBar.destroy();
            MainScene_1.MainIns().progressMgr.removeProgress(this.index);
        }.bind(this)();
    };
    Crop.prototype.initUI = function () {
        var _this = this;
        var _a = this.data.data, petId = _a.petId, level = _a.level, canFeed = _a.canFeed, feedLeftSeconds = _a.feedLeftSeconds, canGather = _a.canGather;
        this.changePetId(petId || 0);
        this.changeState(level || 0);
        if (!this.lastG && canGather) {
            this.changeMv = true;
        }
        this.lastG = canGather;
        this.addCropSvga().then(function () {
            if (_this.petId != CROP_TYPE.NONE) {
                if (canGather) {
                    _this.changeOption(OPTION.GATHER);
                }
                else if (canFeed) {
                    _this.changeOption(OPTION.FEED);
                }
                else if (!canGather && !canFeed) {
                    _this.changeOption(OPTION.PROGRESS);
                }
            }
            else {
                _this.changeOption(OPTION.NONE);
            }
        });
    };
    Crop.prototype.changeOption = function (option) {
        if (option == OPTION.PROGRESS) {
            this.option = option;
            this.optionMv && this.group.removeChild(this.optionMv) && (this.optionMv = null);
            this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.doSpeed, this);
            this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.dOp, this);
            this.touchEnabled = true;
            this.addProgress(this.data.data.feedLeftSeconds);
            if (this.showP) {
                this.showP = false;
                this.progressBar.alpha = 1;
                egret.Tween.removeTweens(this.progressBar);
                egret.Tween.get(this.progressBar).wait(3000).to({ alpha: 0 }, 200, egret.Ease.quartInOut);
            }
            else {
                this.progressBar && (this.progressBar.alpha = 0);
            }
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.dOp, this);
            return;
        }
        if (this.option === option) {
            return;
        }
        this.option = option;
        this.optionMv && this.group.removeChild(this.optionMv) && (this.optionMv = null);
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.doSpeed, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.dOp, this);
        switch (this.option) {
            case OPTION.GATHER:
                this.touchEnabled = true;
                this.addOption('ready_get');
                break;
            case OPTION.FEED:
                this.touchEnabled = true;
                this.addOption(petData[this.petId]['optionSvga']);
                break;
            case OPTION.NONE:
                this.touchChildren = false;
                this.touchEnabled = false;
                this.lastG = false;
                this.showP = false;
                break;
        }
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.dOp, this);
    };
    Crop.prototype.dOp = function () {
        OptionPanel_1.M_HideOption(); // 隐藏操作面板
        this.doOption(this.option);
    };
    Crop.prototype.doOption = function (option) {
        var _this = this;
        switch (option) {
            case OPTION.GATHER:
                MainScene_1.M_SetGameLayerUpdate(false);
                NetManager_1.NetManager.ins.doHarvest(function (success) {
                    if (!success) {
                        MainScene_1.M_SetGameLayerUpdate(true);
                        return;
                    }
                    _this.cropMv && _this.removeChild(_this.cropMv) && (_this.cropMv = null);
                    var catherImg = new eui.Image(petData[_this.petId]['catherImg'] + "_png");
                    var dy = MainScene_1.MainIns().mainUI.height - MainScene_1.MainIns().group.height;
                    catherImg.anchorOffsetX = 57 / 2;
                    catherImg.anchorOffsetY = 63 / 2;
                    catherImg.x = MainScene_1.MainIns().landMgr.lands[_this.index - 1].x + _this.x + 100 + 57 / 2;
                    catherImg.y = MainScene_1.MainIns().landMgr.lands[_this.index - 1].y + _this.y - dy / 2 + 20 + 63 / 2;
                    catherImg.scaleX = 0;
                    catherImg.scaleY = 0;
                    MainScene_1.MainIns().mainUI.addChild(catherImg);
                    // 移动
                    var _x = MainScene_1.MainIns().mainUI.warehouseBtn.x; // + 57 / 2;
                    var _y = MainScene_1.MainIns().mainUI.warehouseBtn.y; // + 63 / 2;
                    egret.Tween.get(catherImg).to({ y: catherImg.y - 10 }, 170)
                        .to({ y: catherImg.y + 10 }, 160, egret.Ease.quadInOut)
                        .to({ y: catherImg.y - 10 }, 160, egret.Ease.quadInOut)
                        .to({ y: catherImg.y + 10 }, 160, egret.Ease.quadInOut)
                        .wait(500)
                        .to({ x: _x, y: _y }, 680);
                    // 缩放
                    egret.Tween.get(catherImg).to({ scaleX: 1, scaleY: 1 }, 170)
                        .wait(500 + 160 + 160)
                        .to({ scaleX: 0.8, scaleY: 1.2 }, 500)
                        .to({ x: 0.8, y: 0.8 }, 330);
                    // 透明度
                    egret.Tween.get(catherImg)
                        .wait(1470 + 160 + 160)
                        .to({ alpha: 0 }, 30)
                        .call(function () {
                        egret.Tween.removeTweens(catherImg);
                        MainScene_1.MainIns().mainUI.removeChild(catherImg);
                        MainScene_1.M_SetGameLayerUpdate(true);
                        LandMgr_1.M_UpdateLand();
                        MainScene_1.MainIns().mainUI.warehouseEffect();
                        Home_1.G_JudgeMedalPanel(); // 检查是否可以弹出勋章
                    });
                    _this.changePetId(CROP_TYPE.NONE);
                    _this.changeState(CROP_STATE.NONE);
                    _this.changeOption(OPTION.NONE);
                }, this.index);
                break;
            case OPTION.FEED:
                MainScene_1.M_SetGameLayerUpdate(false);
                var feedNum = this.data.data.feedNum;
                var haveNum = Home_1.G_GetHomeDataByKey(Home_1.HOME.PROP)[petData[this.petId]['propId']];
                if (feedNum > haveNum) {
                    MainScene_1.M_SetGameLayerUpdate(true);
                    var msg = ((petData[this.petId]['propId'] == 'sp_food_1') ? '饲料' : '水壶') + '不够了，快去做任务吧';
                    UtilsConst_1.showToast(msg);
                }
                else {
                    this.touchEnabled = false;
                    NetManager_1.NetManager.ins.doFeed(function (success) {
                        if (!success) {
                            var msg = ((petData[_this.petId]['propId'] == 'sp_food_1') ? '饲料' : '水壶') + '不够了，快去做任务吧';
                            UtilsConst_1.showToast(msg);
                            MainScene_1.M_SetGameLayerUpdate(true);
                            return;
                        }
                        _this.optionMv && _this.group.removeChild(_this.optionMv) && (_this.optionMv = null);
                        loadSvga_1.loadSvga(utils_1.getSvga(petData[_this.petId]['option'])).then(function (mv) {
                            mv.x = petData[_this.petId]['type'] == 'animal' ? -30 : 10;
                            mv.y = petData[_this.petId]['type'] == 'animal' ? -30 : -120;
                            _this.addChild(mv);
                            mv.addEventListener(egret.Event.COMPLETE, function () {
                                mv.stop();
                                _this.removeChild(mv);
                                MainScene_1.M_SetGameLayerUpdate(true);
                                _this.changeOption(OPTION.NONE);
                                LandMgr_1.M_UpdateLand();
                                Home_1.G_JudgeMedalPanel(); // 检查是否可以弹出勋章
                                _this.showP = true; // 可以显示进度条
                            }, _this);
                        });
                    }, this.index);
                }
                break;
            case OPTION.PROGRESS:
                this.showProgress();
                break;
        }
    };
    Crop.prototype.showProgress = function () {
        this.progressBar && (function () {
            var _this = this;
            egret.Tween.removeTweens(this.progressBar);
            this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.dOp, this);
            this.addSpeed().then(function () {
                egret.Tween.get(_this.progressBar)
                    .to({ alpha: 1 }, 200, egret.Ease.quartInOut)
                    .wait(3000)
                    .call(function () {
                    _this.speedMv && _this.removeChild(_this.speedMv) && (_this.speedMv = null);
                    _this.touchEnabled = true;
                    _this.touchChildren = false;
                })
                    .to({ alpha: 0 }, 200, egret.Ease.quartInOut)
                    .call(function () {
                    // this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.doSpeed, this);
                    _this.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.dOp, _this);
                });
            });
        }.bind(this)());
    };
    Crop.prototype.doSpeed = function () {
        var _this = this;
        console.log('加速');
        NetManager_1.NetManager.ins.useProp(function (success) {
            if (!success) {
                return;
            }
            _this.touchEnabled = false;
            _this.touchChildren = false;
            MainScene_1.M_SetGameLayerUpdate(false);
            egret.Tween.removeTweens(_this.progressBar);
            _this.speedMv && _this.removeChild(_this.speedMv) && (_this.speedMv = null);
            // this.speedMv.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.doSpeed, this);
            _this.progressBar.alpha = 1;
            _this.progressBar.addSpeed(function () {
                MainScene_1.M_SetGameLayerUpdate(true);
                LandMgr_1.M_UpdateLand();
                Home_1.G_JudgeMedalPanel();
            });
        }, 'sp_prop_1', this.index);
    };
    Crop.prototype.addSpeed = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var props = Home_1.G_GetHomeDataByKey(Home_1.HOME.PROP);
            if (props['sp_prop_1'] <= 0) {
                resolve();
                return;
            }
            loadSvga_1.loadSvga(utils_1.getSvga('ready_speed')).then(function (mv) {
                _this.speedMv && _this.removeChild(_this.speedMv) && (_this.speedMv = null);
                _this.speedMv = mv;
                _this.addChild(mv);
                _this.speedMv.x = 80;
                _this.speedMv.y = -85;
                // this.speedMv.touchEnabled = false;
                _this.speedMv.addEventListener(egret.Event.COMPLETE, function () {
                    _this.speedMv && _this.speedMv.gotoAndPlay(11, 1);
                }, _this);
                setTimeout(function () {
                    _this.touchEnabled = true;
                    _this.touchChildren = true;
                    _this.speedMv.touchEnabled = true;
                    _this.speedMv.touchChildren = false;
                    _this.speedMv.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.doSpeed, _this);
                }, 700);
                resolve();
            });
        });
    };
    /**
     * 添加植物的svga
     */
    Crop.prototype.addCropSvga = function () {
        var _this = this;
        return new Promise((function (resolve, reject) {
            if (!_this.changeMv || _this.petId == CROP_TYPE.NONE || _this.state == CROP_STATE.NONE) {
                resolve();
                return;
            }
            _this.cropMv && _this.removeChild(_this.cropMv) && (_this.cropMv = null);
            _this.optionMv && _this.group.removeChild(_this.optionMv) && (_this.optionMv = null);
            var upName = '';
            if ((petData[_this.petId].type == 'plant' && _this.state == 3)
                || (petData[_this.petId].type == 'animal' && _this.state == 4)
                || _this.data.data.canGather) {
                upName = 'up2';
            }
            else {
                upName = 'up1';
            }
            /// TODO 坑爹，1级展示未成熟，2级展示未成熟, 三级展示半成熟，只有可收取才展示成熟
            var mvId = (_this.state == 1) ? _this.state : _this.state - 1;
            // console.log(this.data.data.canGather);
            (_this.data.data.canGather) ? mvId = (petData[_this.petId].type == 'animal' ? 4 : 3) : mvId;
            /// TODO 坑爹，1级展示未成熟，2级展示未成熟, 三级展示半成熟，只有可收取才展示成熟
            loadSvga_1.loadSvga(utils_1.getSvga(upName)).then(// 加载升级动画
            function (upMv) {
                loadSvga_1.loadSvga(utils_1.getSvga("" + petData[_this.petId].key + mvId + "_birth")).then(// 加载出生动画
                function (birthMv) {
                    upMv.gotoAndPlay(1, 1);
                    upMv.x = (upName == 'up2') ? 0 : 10;
                    upMv.y = (upName == 'up2') ? -35 : 20;
                    _this.addChild(upMv);
                    upMv.addEventListener(egret.Event.COMPLETE, function () {
                        _this.removeChild(upMv);
                    }, _this);
                    _this.addChild(birthMv);
                    var pos = (mvId == 3 && _this.petId == 3) ? petData[_this.petId]['catherPos'] : petData[_this.petId]['pos'];
                    birthMv.x = pos[0];
                    birthMv.y = pos[1];
                    birthMv.addEventListener(egret.Event.COMPLETE, function () {
                        birthMv.stop();
                        var name = "" + petData[_this.petId].key + mvId;
                        loadSvga_1.loadSvga(utils_1.getSvga(name)).then(function (mv) {
                            _this.removeChild(birthMv);
                            _this.addChildAt(mv, 0);
                            _this.cropMv = mv;
                            _this.cropMv.x = pos[0];
                            _this.cropMv.y = pos[1];
                            _this.cropMv.pixelHitTest = true;
                            resolve();
                        });
                    }, _this);
                });
            });
            _this.changeMv = false;
        }));
    };
    /**
     * 添加操作的svga
     * @param name
     */
    Crop.prototype.addOption = function (name) {
        var _this = this;
        this.optionMv && this.group.removeChild(this.optionMv) && (this.optionMv = null);
        loadSvga_1.loadSvga(utils_1.getSvga(name)).then(function (optionMv) {
            _this.optionMv = optionMv;
            _this.group.addChild(_this.optionMv);
            _this.optionMv.x = 80;
            _this.optionMv.y = -85;
            _this.optionMv.touchEnabled = false;
            _this.optionMv.addEventListener(egret.Event.COMPLETE, function () {
                _this.optionMv && _this.optionMv.gotoAndPlay(11, 1);
            }, _this);
        });
    };
    Crop.prototype.addProgress = function (nTime) {
        var label = '';
        if (petData[this.petId]['type'] == 'animal') {
            label = (this.state == 4) ? '收获' : '喂食';
        }
        else {
            label = (this.state == 3) ? '收获' : '浇水';
        }
        MainScene_1.MainIns() && (this.progressBar = MainScene_1.MainIns().progressMgr.addProgress({
            index: this.data.index,
            x: this.data.x + 88,
            y: this.data.y + 193,
            title: petData[this.petId].name,
            label: label,
            sTime: 8 * 60 * 60,
            nTime: nTime,
            eTime: 0
        }));
    };
    // 改变状态积
    Crop.prototype.changeState = function (state) {
        if (state == this.state) {
            return;
        }
        this.changeMv = true;
        this.state = state; // 设置状态
        /// TODO 定义详细的状态积
        switch (this.state) {
            case CROP_STATE.NONE:// 啥也没有
                this.cropMv && this.removeChild(this.cropMv) && (this.cropMv = null);
                this.optionMv && this.group.removeChild(this.optionMv) && (this.optionMv = null);
                break;
            case CROP_STATE.LEVEL1:// 刚种
                break;
            case CROP_STATE.LEVEL2:// 半成熟
                break;
            case CROP_STATE.LEVEL3:// 植物成熟
                break;
            case CROP_STATE.LEVEL4:// 动物成熟
                break;
            default:
                break;
        }
    };
    // 改变类型
    Crop.prototype.changePetId = function (petId) {
        if (petId == this.petId) {
            return;
        }
        this.changeMv = true;
        this.petId = petId; // 设置Id
        /// TODO 定义详细类型积
        switch (petId) {
            case 0:// 啥也没有
                this.cropMv && this.removeChild(this.cropMv) && (this.cropMv = null);
                this.optionMv && this.group.removeChild(this.optionMv) && (this.optionMv = null);
                break;
            case 1:// 鸡
                break;
            case 2:// 小麦
                break;
            case 3:// 牛
                break;
            case 4:// 玉米
                break;
            default:
                break;
        }
    };
    return Crop;
}(eui.Component));
exports.default = Crop;
__reflect(Crop.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/Objs/Crop\".Crop");
//# sourceMappingURL=Crop.js.map