"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var ComponentBase_1 = require("../../components/ComponentBase");
var OptionPanel_1 = require("./Objs/OptionPanel");
var panelCtrl_1 = require("../../ctrls/panelCtrl");
var sceneTypes_1 = require("../../types/sceneTypes");
var UtilsConst_1 = require("../../comm/UtilsConst");
var MainScene_1 = require("./MainScene");
var NetManager_1 = require("../../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../../libs/tw/manager/DataManager");
var loadSvga_1 = require("../../comm/loadSvga");
var utils_1 = require("../../utils");
var getlogItem_1 = require("../../comm/getlogItem");
var sceneCtrl_1 = require("../../ctrls/sceneCtrl");
var Home_1 = require("../Home");
exports.propData = {
    sp_food_1: { name: 'food', },
    sp_food_2: { name: 'water', },
    sp_prop_1: { name: 'speed', },
};
var MainUI = (function (_super) {
    __extends(MainUI, _super);
    function MainUI() {
        return _super.call(this) || this;
    }
    MainUI.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this, OptionPanel_1.M_HideOption, this],
            [this.taskBtn, this.onTap, this],
            [this.warehouseBtn, this.onTap, this],
            [this.recordBtn, this.onTap, this],
            [this.shopBtn, this.onTap, this],
            [this.avatarImg, this.onTap, this],
            [this.houseBtn, this.onTap, this],
        ]).concat([
            [this.foodGroup, this.onTapOption, this],
            [this.waterGroup, this.onTapOption, this],
            [this.speedGroup, this.onTapOption, this],
        ]);
    };
    MainUI.prototype.onTapOption = function (e) {
        UtilsConst_1.btnDelay(e.target);
        switch (e.target) {
            case this.foodGroup:// 食物数量区域
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(6));
                UtilsConst_1.showToast('点击饿了的动物才能进行喂食哦');
                break;
            case this.waterGroup:// 水壶数量区域
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(7));
                UtilsConst_1.showToast('点击渴了的植物才能浇水哦');
                break;
            case this.speedGroup:
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(18));
                UtilsConst_1.showToast('点击植物/动物去加速成长时间');
                break;
            default:
                break;
        }
    };
    /// TODO 定义详细操作
    MainUI.prototype.onTap = function (e) {
        UtilsConst_1.btnDelay(e.target);
        switch (e.target) {
            case this.taskBtn:// 任务按钮
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(3));
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TASK_PANEL);
                break;
            case this.warehouseBtn:// 仓库按钮
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(4));
                Home_1.G_UpdateHomeData().then(function () {
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.WAREHOUSE_PANEL, Home_1.G_GetHomeDataByKey(Home_1.HOME.PRODUCT));
                });
                break;
            case this.avatarImg:// 头像
                // window['share']();
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(1)); // 头像点击埋点
                break;
            case this.recordBtn:// 兑换记录
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(2)); // 售卖记录点击
                window.location.href = window['record'];
                break;
            case this.shopBtn:// 商店
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(5)); // 商店点击埋点
                Home_1.G_UpdateHomeData().then(function () {
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.SHOP_SCENE);
                });
                break;
            case this.houseBtn:
                sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.ROOM_SCENE);
                break;
            default:
                break;
        }
    };
    MainUI.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    MainUI.prototype.initUI = function () {
        this.uiLayer.height = 750 / window.innerWidth * window.innerHeight;
        this.touchEnabled = true;
        this.warehouseBtn.anchorOffsetX = 53.5;
        this.warehouseBtn.anchorOffsetY = 60.5;
        this.houseBtn.y = (this.houseBtn.y - (MainScene_1.MainIns().gameLayer.height - MainScene_1.MainIns().group.height) / 2);
        this.avatarImg.mask = this.avatarMask;
        this.getUserInfo();
        this.getGoldNum();
        this.getPropInfoByBI();
        // 埋点
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(1)); // 头像曝光
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(2)); // 兑换记录
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(3)); // 任务按钮
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(4)); // 仓库按钮
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(5)); // 商店按钮
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(6)); // 饲料区域
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(7)); // 水区域
        /// TODO 根据数据初始化头像Panel
        this.warehouseBtn.anchorOffsetX = 53.5;
        this.warehouseBtn.anchorOffsetY = 60.5;
    };
    MainUI.prototype.addGold = function () {
        var _this = this;
        loadSvga_1.loadSvga(utils_1.getSvga('欢趣豆收取')).then(function (mv) {
            mv.x = _this.avatarPanel.x + 100;
            mv.y = _this.avatarPanel.y;
            _this.addChild(mv);
            mv.addEventListener(egret.Event.COMPLETE, function () {
                mv.stop();
                _this.removeChild(mv);
                _this.getGoldNum();
            }, _this);
        });
    };
    MainUI.prototype.warehouseEffect = function () {
        // 0s(100%,100%)-0.1s(120%,80%)-0.2s(100%,100%)
        egret.Tween.removeTweens(this.warehouseBtn);
        egret.Tween.get(this.warehouseBtn)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 100, egret.Ease.quadInOut)
            .to({ scaleX: 1, scaleY: 1 }, 100, egret.Ease.quadInOut);
    };
    MainUI.prototype.getPropInfo = function () {
        var _this = this;
        Home_1.G_UpdateHomeData().then(function () {
            _this[exports.propData['sp_food_1'].name + "Group"].visible = true;
            _this[exports.propData['sp_food_2'].name + "Group"].visible = true;
            _this.setPropInfo();
        });
    };
    MainUI.prototype.getPropInfoByBI = function () {
        var _this = this;
        Home_1.G_UpdateHomeData().then(function () {
            _this[exports.propData['sp_food_1'].name + "Group"].visible = true;
            _this[exports.propData['sp_food_2'].name + "Group"].visible = true;
            _this.setPropInfoByBI();
        });
    };
    MainUI.prototype.setPropInfoByBI = function () {
        var data = Home_1.G_GetHomeDataByKey(Home_1.HOME.PROP);
        for (var k in exports.propData) {
            this[exports.propData[k].name + "Num"].text = '× ' + data[k];
            DataManager_1.DataManager.ins.updateData(exports.propData[k].name, data[k]);
        }
        if (data['sp_prop_1'] > 0) {
            NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(18)); // 加速卡区域
            this[exports.propData['sp_prop_1'].name + "Group"].visible = true;
        }
        else {
            this[exports.propData['sp_prop_1'].name + "Group"].visible = false;
        }
    };
    MainUI.prototype.setPropInfo = function () {
        var data = Home_1.G_GetHomeDataByKey(Home_1.HOME.PROP);
        for (var k in exports.propData) {
            this[exports.propData[k].name + "Num"].text = '× ' + data[k];
            DataManager_1.DataManager.ins.updateData(exports.propData[k].name, data[k]);
        }
        this[exports.propData['sp_prop_1'].name + "Group"].visible = (data['sp_prop_1'] > 0);
    };
    MainUI.prototype.getGoldNum = function () {
        var _this = this;
        NetManager_1.NetManager.ins.getProjectUserInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = res.data;
            _this.userGold.text = data.unitName + "\uFF1A" + data.consumerCredits;
            Home_1.G_SetHomeDataByKey(Home_1.HOME.GOLD, data.consumerCredits);
        });
    };
    MainUI.prototype.getUserInfo = function () {
        var _this = this;
        NetManager_1.NetManager.ins.getConsumerInfo(function (success, res) {
            if (!success) {
                _this.userName.text = '欢趣使者';
                return;
            }
            var data = res.data;
            _this.userName.text = (!data || !data.nickname || (data.nickname == 'null'))
                ? '欢趣使者' : ((data.nickname.length > 7) ? data.nickname.slice(0, 7) + '...' : data.nickname);
        });
    };
    MainUI.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(MainUI.prototype, "skinKey", {
        get: function () {
            return 'MainUI';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainUI.prototype, "groupName", {
        get: function () {
            return 'main_ui';
        },
        enumerable: true,
        configurable: true
    });
    return MainUI;
}(ComponentBase_1.default));
exports.default = MainUI;
__reflect(MainUI.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/MainUI\".MainUI");
//# sourceMappingURL=MainUI.js.map