"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = require("../../views/Scene");
var MainUI_1 = require("./MainUI");
var LandMgr_1 = require("./LandMgr");
var OptionPanel_1 = require("./Objs/OptionPanel");
var Dispatcher_1 = require("../../comm/Dispatcher");
var ProgressMgr_1 = require("./ProgressMgr");
////////////////// Instance //////////////////
var instance = null;
var MainIns = function () {
    return instance;
};
exports.MainIns = MainIns;
var SetMainInstance = function (ins) {
    instance = ins;
};
var DestroyMainInstance = function () {
    instance = null;
};
var canUpdate = true;
var M_SetGameLayerUpdate = function (enable) {
    instance.gameLayer.touchEnabled = enable;
    instance.gameLayer.touchChildren = enable;
    canUpdate = enable;
};
exports.M_SetGameLayerUpdate = M_SetGameLayerUpdate;
var M_CanUpdate = function () {
    return canUpdate;
};
exports.M_CanUpdate = M_CanUpdate;
////////////////// Instance //////////////////
// Index场景的事件收发器
var MainDispatcher = null;
exports.MainDispatcher = MainDispatcher;
var NewMainDispatcher = function () {
    exports.MainDispatcher = MainDispatcher = new Dispatcher_1.default();
};
var DestroyMainDispatcher = function () {
    exports.MainDispatcher = MainDispatcher = null;
};
/**
 * 主场景
 * Tips：
 *   1.在本场景中因为需求坑爹（需要上下居中适配并加固定导航栏），所以进行手动适配
 *   2.在MainScene中：
 *       group 为适配层，该层 height = 实际画布高度
 *       gameLayer 为游戏层，该层在 group 中上下居中
 *       获得高度差可用 gameLayer.height - group.height
 *       需要将非 gameLayer 层中对象准确定位可将定位高度减去 上面的值/2 -> (1624 - 750 / window.innerWidth * window.innerHeight) / 2
 *   3.使用上面的 MainIns() 可取得IndexScene的场景单例，该单例在MainScene场景销毁时会自动销毁，MainScene场景生成时自动赋值
 *   4.使用上面的 MainDispatcher 可取得独立在MainScene的场景中的事件收发器单例，该单例在MainScene场景销毁时会自动销毁，MainScene场景生成时自动赋值
 */
var MainScene = (function (_super) {
    __extends(MainScene, _super);
    function MainScene(data) {
        var _this = _super.call(this, data) || this;
        _this.landMgr = null;
        return _this;
    }
    MainScene.prototype.start = function () {
        _super.prototype.start.call(this);
        SetMainInstance(this); // 设置单例
        NewMainDispatcher(); // 创建一个局部事件收发器
        M_SetGameLayerUpdate(true);
        this.initUI();
    };
    MainScene.prototype.initUI = function () {
        this.group.height = 750 / window.innerWidth * window.innerHeight;
        // 创建UI层
        this.mainUI = new MainUI_1.default();
        this.addChild(this.mainUI);
        this.gameLayer.touchThrough = true; // 点击穿透。。防止设计touchEnable后无法点击bg
        // 创建进度条管理器
        this.progressMgr = new ProgressMgr_1.default();
        // 创建土地管理器
        this.gameLayer.touchEnabled = false;
        this.landMgr = new LandMgr_1.default(this);
        // 创建操作Panel（初始为隐藏状态）
        this.optionPanel = OptionPanel_1.default.getInstance();
        this.addChild(this.optionPanel);
    };
    MainScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        /// TODO 可能的需要清除的东西
        M_SetGameLayerUpdate(false);
        OptionPanel_1.default.destroy();
        this.mainUI.destroy();
        this.progressMgr.destroy();
        this.landMgr.destroy();
        DestroyMainDispatcher(); // 删除局部收发器
        DestroyMainInstance(); // 清除单例
        egret.Tween.removeAllTweens();
    };
    MainScene.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.bg, this.onTouchTap, this],
        ]);
    };
    MainScene.prototype.onTouchTap = function (e) {
        switch (e.target) {
            case this.bg:
                OptionPanel_1.M_HideOption();
                break;
            default:
                break;
        }
    };
    MainScene.prototype.preLoadRes = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/];
            });
        });
    };
    Object.defineProperty(MainScene.prototype, "skinKey", {
        get: function () {
            return 'MainScene';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainScene.prototype, "groupName", {
        get: function () {
            return 'main_scene';
        },
        enumerable: true,
        configurable: true
    });
    return MainScene;
}(Scene_1.default));
exports.default = MainScene;
__reflect(MainScene.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/MainScene\".MainScene");
//# sourceMappingURL=MainScene.js.map