"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Land_1 = require("./Objs/Land");
var MainScene_1 = require("./MainScene");
var NetManager_1 = require("../../../libs/tw/manager/NetManager");
var GDispatcher_1 = require("../../../libs/tc/util/GDispatcher");
var loadSvga_1 = require("../../comm/loadSvga");
var utils_1 = require("../../utils");
var MSceneEnum_1 = require("./MSceneEnum");
var OptionPanel_1 = require("./Objs/OptionPanel");
/**
 * 示意图
 *    ////////////
 *   /////1 1////    ////////////
 *  /////1 1////    /////2 2////
 * ////////////    /////2 2////
 *                ////////////
 *    ////////////
 *   /////3 3////    ////////////
 *  /////3 3////    /////4 4////
 * ////////////    /////4 4////
 *                ////////////
 */
var landPos = [
    { x: 170, y: 669 },
    { x: 396, y: 778 },
    { x: 43, y: 851 },
    { x: 288, y: 972 },
];
var LandMgr = (function () {
    function LandMgr(parent) {
        this._parent = null;
        this.lands = [];
        this._parent = parent;
        this.initEvents();
        this.getLandInfo();
    }
    Object.defineProperty(LandMgr.prototype, "parent", {
        get: function () {
            return this._parent;
        },
        enumerable: true,
        configurable: true
    });
    LandMgr.prototype.initEvents = function () {
        MainScene_1.MainDispatcher.addEvent(MSceneEnum_1.default.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher_1.GDispatcher.addEvent('docVisible', this.updateLandInfo, this);
        MainScene_1.MainDispatcher.addEvent(MSceneEnum_1.default.UPDATE_LANDS, this.updateLandInfo, this);
        MainScene_1.MainDispatcher.addEvent(MSceneEnum_1.default.PLANT, this.plant, this);
    };
    LandMgr.prototype.destroy = function () {
        for (var i = 0; i < this.lands.length; i++) {
            this.lands[i].destroy();
            this.lands[i] = null;
        }
        MainScene_1.MainDispatcher.removeEvent(MSceneEnum_1.default.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher_1.GDispatcher.removeEvent('docVisible', this.updateLandInfo, this);
        MainScene_1.MainDispatcher.removeEvent(MSceneEnum_1.default.UPDATE_LANDS, this.updateLandInfo, this);
        MainScene_1.MainDispatcher.removeEvent(MSceneEnum_1.default.PLANT, this.plant, this);
    };
    LandMgr.prototype.plant = function (data) {
        this.lands[data.landId - 1].plant(data);
    };
    LandMgr.prototype.reActiveAll = function () {
        this.lands.forEach(function (v) { return v.reActive(); });
    };
    /**
     * 添加地块
     */
    LandMgr.prototype.addLand = function (data) {
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var v = data_1[_i];
            var newLand = new Land_1.default({ data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y });
            MainScene_1.MainIns().gameLayer.addChildAt(newLand, v.id);
            this.lands.push(newLand); // 加入数组方便管理
        }
        loadSvga_1.loadSvga(utils_1.getSvga('流水动效')).then(function (mv) {
            mv.x = 550;
            mv.y = 865;
            mv.touchEnabled = false;
            MainScene_1.MainIns().gameLayer.addChildAt(mv, 3);
        });
    };
    LandMgr.prototype.getLandInfo = function () {
        var _this = this;
        NetManager_1.NetManager.ins.getLandInfo(function (success, res) {
            if (!success) {
                return;
            }
            _this.addLand(res.data);
        });
    };
    LandMgr.prototype.updateLandInfo = function () {
        var _this = this;
        console.log('Update Lands');
        NetManager_1.NetManager.ins.getLandInfo(function (success, res) {
            OptionPanel_1.M_HideOption();
            if (!success) {
                return;
            }
            for (var i = 0; i < res.data.length; i++) {
                var v = res.data[i];
                _this.lands[i].updateData({ data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y });
            }
        });
    };
    return LandMgr;
}());
exports.default = LandMgr;
__reflect(LandMgr.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/MainScene/LandMgr\".LandMgr");
var M_UpdateLand = function () {
    MainScene_1.MainDispatcher.dispatchEvent(MSceneEnum_1.default.UPDATE_LANDS);
};
exports.M_UpdateLand = M_UpdateLand;
var M_Plant = function (data) {
    MainScene_1.MainDispatcher.dispatchEvent(MSceneEnum_1.default.PLANT, data);
};
exports.M_Plant = M_Plant;
//# sourceMappingURL=LandMgr.js.map