"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var UtilsConst_1 = require("../comm/UtilsConst");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var MainScene_1 = require("./MainScene/MainScene");
var HomeData = {
    gold: 0,
    prop: {
        sp_food_1: 0,
        sp_food_2: 0,
        sp_prop_1: 0,
    },
    product: {
        sp_1: 0,
        sp_2: 0,
        sp_3: 0,
        sp_4: 0,
    },
    medals: {
        sp_achv_1: {
            name: '进击的农夫',
            count: 0
        },
        sp_achv_2: {
            name: '丰收的季节',
            count: 0
        },
    },
};
var HOME;
(function (HOME) {
    HOME["GOLD"] = "gold";
    HOME["PROP"] = "prop";
    HOME["PRODUCT"] = "product";
    HOME["MEDALS"] = "medals";
})(HOME = exports.HOME || (exports.HOME = {}));
/**
 * 刷新拥有的产物，使用数据之前要刷新，如打开仓库、打开商店
 */
exports.G_UpdateHomeData = function () {
    var updateGold = new Promise(function (resolve, reject) {
        NetManager_1.NetManager.ins.getProjectUserInfo(function (success, res) {
            if (!success) {
                return;
            }
            exports.G_SetHomeDataByKey(HOME.GOLD, res.data.consumerCredits);
            resolve();
        });
    });
    var updateSp = new Promise(function (resolve, reject) {
        NetManager_1.NetManager.ins.queryUserSpList(function (success, res) {
            if (!success) {
                return;
            }
            for (var k in HomeData.prop) {
                HomeData.prop[k] = res.data[k];
            }
            for (var k in HomeData.product) {
                HomeData.product[k] = res.data[k];
            }
            for (var k in HomeData.medals) {
                HomeData.medals[k].count = res.data[k];
            }
            if (MainScene_1.MainIns()) {
                MainScene_1.MainIns().mainUI.setPropInfo();
            }
            resolve();
        });
    });
    return Promise.all([updateGold, updateSp]);
};
exports.G_GetHomeData = function () {
    return UtilsConst_1.deepClone(HomeData);
};
exports.G_GetHomeDataByKey = function (key) {
    return UtilsConst_1.deepClone(HomeData[key]) || null;
};
exports.G_SetHomeDataByKey = function (key, val) {
    HomeData[key] = val;
};
/**
 * 检查是否可以弹出勋章弹窗
 */
exports.G_JudgeMedalPanel = function () {
    var oldData = exports.G_GetHomeDataByKey(HOME.MEDALS);
    exports.G_UpdateHomeData().then(function () {
        var newData = exports.G_GetHomeDataByKey(HOME.MEDALS);
        var _loop_1 = function (k) {
            if (newData[k].count > oldData[k].count) {
                setTimeout(function () {
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MEDAL_PANEL, k);
                }, 500);
                return { value: void 0 };
            }
        };
        for (var k in newData) {
            var state_1 = _loop_1(k);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    });
};
//# sourceMappingURL=Home.js.map