"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var UtilsConst_1 = require("../comm/UtilsConst");
var MainScene_1 = require("../Scenes/MainScene/MainScene");
var getlogItem_1 = require("../comm/getlogItem");
var Home_1 = require("../Scenes/Home");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
exports.productData = {
    'sp_1': {
        key: 'sp_1',
        name: 'egg',
        nameLabel: '鸡蛋',
        numLabel: '个',
        titleImg: 'sellTitle_egg_png',
        price: 0,
    },
    'sp_2': {
        key: 'sp_2',
        name: 'wheat',
        nameLabel: '麦粉',
        numLabel: '袋',
        titleImg: 'sellTitle_wheat_png',
        price: 0,
    },
    'sp_3': {
        key: 'sp_3',
        name: 'corn',
        nameLabel: '玉米',
        numLabel: '个',
        titleImg: 'sellTitle_corn_png',
        price: 0,
    },
    'sp_4': {
        key: 'sp_4',
        name: 'milk',
        nameLabel: '牛奶',
        numLabel: '瓶',
        titleImg: 'sellTitle_milk_png',
        price: 0,
    }
};
var posArr = [
    [0, 0],
    [354, 0],
    [0, 359],
    [354, 359],
];
var WareHousePanel = (function (_super) {
    __extends(WareHousePanel, _super);
    function WareHousePanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(WareHousePanel.prototype, "skinKey", {
        get: function () {
            return 'WareHouse';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WareHousePanel.prototype, "groupName", {
        get: function () {
            return 'warehouse';
        },
        enumerable: true,
        configurable: true
    });
    WareHousePanel.prototype.onShowAnim = function () {
        var canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ y: canvasH }).to({ y: canvasH - 715 }, 300, egret.Ease.quadInOut);
    };
    WareHousePanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.record_btn, this.onTap, this],
        ]);
    };
    WareHousePanel.prototype.onTap = function (e) {
        switch (e.target) {
            case this.record_btn:// 售卖记录
                UtilsConst_1.btnDelay(this.record_btn);
                topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SELL_RECORD, {}, .3);
                break;
            default:
                break;
        }
    };
    WareHousePanel.prototype.start = function () {
        _super.prototype.start.call(this);
        NetManager_1.NetManager.ins.priceInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = res.data;
            for (var k in exports.productData) {
                exports.productData[k].price = data[k];
            }
        });
        this.initUI();
    };
    WareHousePanel.prototype.initUI = function () {
        this.setUI(this.data);
        MainScene_1.MainDispatcher.addEvent('updateWareHouse', this.getWareHouseInfo, this);
        MainScene_1.MainDispatcher.addEvent('closeWareHouse', this.onTouchClose, this);
    };
    WareHousePanel.prototype.onTouchClose = function () {
        return _super.prototype.onTouchClose.call(this);
    };
    WareHousePanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        MainScene_1.MainDispatcher.removeEvent('updateWareHouse', this.getWareHouseInfo, this);
        MainScene_1.MainDispatcher.removeEvent('closeWareHouse', this.onTouchClose, this);
    };
    /**
     * 仓库排列
     * @param res
     */
    WareHousePanel.prototype.setUI = function (res) {
        var _this = this;
        var data = this.data;
        var showKey = [];
        var _loop_1 = function (k) {
            if (data[k] <= 0) {
                this_1[exports.productData[k].name + "_group"].visible = false;
            }
            else {
                showKey.push(k);
                NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(16));
                NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(17));
                this_1[exports.productData[k].name + "_label"].text = "\u6570\u91CF\uFF1A" + data[k];
                this_1[exports.productData[k].name + "_sell_btn"].addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
                    NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(16));
                    UtilsConst_1.btnDelay(_this[exports.productData[k].name + "_sell_btn"]);
                    topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SELL_PANEL, { key: k, total: data[k] }, .4);
                });
                this_1[exports.productData[k].name + "_ex_btn"].addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
                    NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(17));
                    UtilsConst_1.btnDelay(_this[exports.productData[k].name + "_ex_btn"]);
                    // showToast('欢趣商店待开放，过段日子再来吧~');
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.SHOP_SCENE);
                });
            }
        };
        var this_1 = this;
        for (var k in exports.productData) {
            _loop_1(k);
        }
        for (var i = 0; i < showKey.length; i++) {
            this[exports.productData[showKey[i]].name + "_group"].x = posArr[i][0];
            this[exports.productData[showKey[i]].name + "_group"].y = posArr[i][1];
        }
        this.crops.visible = (showKey.length > 0);
        this.noneImg.visible = !(showKey.length > 0);
    };
    WareHousePanel.prototype.getWareHouseInfo = function () {
        var _this = this;
        Home_1.G_UpdateHomeData().then(function () {
            _this.setUI(Home_1.G_GetHomeDataByKey(Home_1.HOME.PRODUCT));
        });
    };
    return WareHousePanel;
}(Panel_1.default));
exports.default = WareHousePanel;
__reflect(WareHousePanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/WareHousePanel\".WareHousePanel");
//# sourceMappingURL=WareHousePanel.js.map