"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var UtilsConst_1 = require("../comm/UtilsConst");
var Home_1 = require("../Scenes/Home");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var ShopBuyPanel = (function (_super) {
    __extends(ShopBuyPanel, _super);
    function ShopBuyPanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(ShopBuyPanel.prototype, "skinKey", {
        get: function () {
            return 'ShopBuyPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShopBuyPanel.prototype, "groupName", {
        get: function () {
            return 'shop_buy';
        },
        enumerable: true,
        configurable: true
    });
    ShopBuyPanel.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    ShopBuyPanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.btn, this.onTap, this],
        ]);
    };
    ShopBuyPanel.prototype.onTap = function () {
        var _this = this;
        // 欢趣豆不足
        if (Home_1.G_GetHomeDataByKey(Home_1.HOME.GOLD) < this.data.price) {
            UtilsConst_1.showToast('啊哦，欢趣豆不足，快去攒豆吧');
            return;
        }
        // 无库存
        if (this.data.stock <= 0) {
            UtilsConst_1.showToast('啊哦，道具没有啦，晚点再来兑换吧');
            return;
        }
        this.btn.touchEnabled = false;
        // 预扣积分
        this.creditsCost().then(function (ticket) {
            // 兑换商品
            NetManager_1.NetManager.ins.propExchange(function (success, res) {
                _this.btn.touchEnabled = true;
                if (!success) {
                    UtilsConst_1.showToast('啊哦...目前无法兑换哦');
                    return;
                }
                UtilsConst_1.showToast('兑换成功，可返回农场使用');
                GDispatcher_1.GDispatcher.dispatchEvent('shopUpdate');
                _this.onTouchClose();
            }, _this.data.spId, ticket);
        }).catch(function () {
            _this.btn.touchEnabled = true;
            UtilsConst_1.showToast('啊哦...目前无法兑换哦');
        });
    };
    ShopBuyPanel.prototype.creditsCost = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            NetManager_1.NetManager.ins.creditsCost(function (success, res) {
                if (!success) {
                    reject();
                    return;
                }
                var ticket = res.data;
                // 轮询扣积分状态
                NetManager_1.NetManager.ins.queryStatus(function (success, res) {
                    if (!success || res.data != 1) {
                        reject();
                        return;
                    }
                    resolve(ticket);
                }, ticket, function (res) {
                    return res.data == 0;
                });
            }, 'join_7', 'join', '欢趣农场', _this.data.price);
        });
    };
    ShopBuyPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    ShopBuyPanel.prototype.initUI = function () {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        this.title.text = this.data.title;
        this.titleImg.source = "shop_buy_" + this.data.name + "_png";
        this.price.text = "\u6240\u9700\u6B22\u8DA3\u8C46\uFF1A" + this.data.price;
        this.introduce.text = "\u529F\u80FD\u4ECB\u7ECD\uFF1A" + this.data.introduce;
    };
    ShopBuyPanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return ShopBuyPanel;
}(Panel_1.default));
exports.default = ShopBuyPanel;
__reflect(ShopBuyPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/ShopBuyPanel\".ShopBuyPanel");
//# sourceMappingURL=ShopBuyPanel.js.map