"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var utils_1 = require("../utils");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var SellRecord = (function (_super) {
    __extends(SellRecord, _super);
    function SellRecord(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(SellRecord.prototype, "skinKey", {
        get: function () {
            return 'SellRecord';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SellRecord.prototype, "groupName", {
        get: function () {
            return 'sellRecord';
        },
        enumerable: true,
        configurable: true
    });
    SellRecord.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    SellRecord.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    SellRecord.prototype.initUI = function () {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.1;
        this.getSellInfo();
    };
    SellRecord.prototype.getSellInfo = function () {
        var _this = this;
        NetManager_1.NetManager.ins.getSellInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = res.data;
            _this.list.useVirtualLayout = false;
            _this.list.itemRenderer = SellRecordItem;
            _this.list.dataProvider = new eui.ArrayCollection(data);
        });
    };
    return SellRecord;
}(Panel_1.default));
exports.default = SellRecord;
__reflect(SellRecord.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/SellRecord\".SellRecord");
////////////////////////////////////////////////////////////////////////////////////////////////
var spData = {
    'sp_1': '个鸡蛋',
    'sp_2': '袋小麦',
    'sp_3': '个玉米',
    'sp_4': '瓶牛奶',
};
// 任务中心列表
var SellRecordItem = (function (_super) {
    __extends(SellRecordItem, _super);
    function SellRecordItem() {
        var _this = _super.call(this) || this;
        _this.skinName = utils_1.getSkinPath('SellRecordItem');
        return _this;
    }
    SellRecordItem.prototype.dataChanged = function () {
        var _a = this.data, date = _a.date, spCount = _a.spCount, sp = _a.sp, credits = _a.credits;
        var nd = new Date(date);
        this.cropLabel.text = spCount + spData[sp];
        this.dateLabel.text = nd.getFullYear() + "." + (nd.getMonth() + 1) + "." + nd.getDate();
        this.creditsLabel.text = credits + "\u4E2A\u6B22\u8DA3\u8C46";
    };
    return SellRecordItem;
}(eui.ItemRenderer));
__reflect(SellRecordItem.prototype, "SellRecordItem");
//# sourceMappingURL=SellRecord.js.map