"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var WareHousePanel_1 = require("./WareHousePanel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var ProgressNum_1 = require("../components/ProgressNum");
var MainScene_1 = require("../Scenes/MainScene/MainScene");
var sceneTypes_1 = require("../types/sceneTypes");
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var SellPanel = (function (_super) {
    __extends(SellPanel, _super);
    function SellPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.total = 0; // 总个数
        _this.numBar = null;
        return _this;
    }
    Object.defineProperty(SellPanel.prototype, "skinKey", {
        get: function () {
            return 'SellPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SellPanel.prototype, "groupName", {
        get: function () {
            return 'sell_panel';
        },
        enumerable: true,
        configurable: true
    });
    SellPanel.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    SellPanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.sellBtn, this.doSell, this],
        ]);
    };
    SellPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
        MainScene_1.MainDispatcher.addEvent('updateSellValue', this.updateSellValue, this);
    };
    SellPanel.prototype.updateSellValue = function () {
        var value = this.numBar.value;
        this.sellBtn.enabled = (value > 0);
    };
    SellPanel.prototype.initUI = function () {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        this.key = this.data.key;
        this.total = this.data.total;
        var d = WareHousePanel_1.productData[this.key];
        this.infoLabel.text = "\u4E00" + WareHousePanel_1.productData[this.key].numLabel + WareHousePanel_1.productData[this.key].nameLabel + "=" + WareHousePanel_1.productData[this.key].price + "\u4E2A\u6B22\u8DA3\u8C46";
        this.nameLabel.text = d.nameLabel;
        this.titleImg.source = "sellTitle_" + d.name + "_png";
        this.totalLabel.text = "\u5171" + this.data.total + d.numLabel;
        this.numBar = new ProgressNum_1.ProgressNum({ total: this.total });
        this.addChild(this.numBar);
        this.numBar.x = this.width / 2 - this.numBar.width / 2;
        this.numBar.y = 400;
        this.updateSellValue();
    };
    /**
     * 发起售卖
     */
    SellPanel.prototype.doSell = function () {
        var _this = this;
        this.sellBtn.touchEnabled = false;
        var count = this.numBar.value;
        NetManager_1.NetManager.ins.doSell(function (success, res) {
            _this.sellBtn.touchEnabled = true;
            if (!success) {
                return;
            }
            var total = _this.numBar.value * WareHousePanel_1.productData[_this.key].price;
            topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SELLED_PANEL, { name: WareHousePanel_1.productData[_this.key].nameLabel, total: total }, .4);
        }, this.key, count);
    };
    SellPanel.prototype.destroy = function () {
        this.numBar.destroy();
        _super.prototype.destroy.call(this);
    };
    return SellPanel;
}(Panel_1.default));
exports.default = SellPanel;
__reflect(SellPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/SellPanel\".SellPanel");
//# sourceMappingURL=SellPanel.js.map