"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var UtilsConst_1 = require("../comm/UtilsConst");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var ExchangedPanel = (function (_super) {
    __extends(ExchangedPanel, _super);
    function ExchangedPanel(data) {
        return _super.call(this, data) || this;
    }
    ExchangedPanel.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    ExchangedPanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.btn, this.onTap, this],
            [this.record, this.onTap, this],
        ]);
    };
    ExchangedPanel.prototype.onTap = function (e) {
        UtilsConst_1.btnDelay(e.target);
        switch (e.target) {
            case this.btn:
                this.onTouchClose();
                break;
            case this.record:
                window.location.href = window['record'];
                break;
            default:
                break;
        }
    };
    ExchangedPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    ExchangedPanel.prototype.initUI = function () {
        var _this = this;
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        NetManager_1.NetManager.ins.queryPrizeInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = res.data[0];
            _this.title.text = data.name;
            var title = data.name.split('_@_');
            _this.title.text = title[0];
            _this.prizeImg.source = data.icon;
        }, this.data.prizeId);
        GDispatcher_1.GDispatcher.dispatchEvent('shopUpdate');
    };
    ExchangedPanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(ExchangedPanel.prototype, "skinKey", {
        get: function () {
            return 'ExchangedPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ExchangedPanel.prototype, "groupName", {
        get: function () {
            return 'exchanged_panel';
        },
        enumerable: true,
        configurable: true
    });
    return ExchangedPanel;
}(Panel_1.default));
exports.default = ExchangedPanel;
__reflect(ExchangedPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/ExchangedPanel\".ExchangedPanel");
//# sourceMappingURL=ExchangedPanel.js.map