"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("./../../manager/NetManager");
var DataManager_1 = require("./../../manager/DataManager");
var GameModel_1 = require("../common/GameModel");
var GMath_1 = require("../../../tc/util/GMath");
var GCache_1 = require("../../../tc/util/GCache");
// import { IDynamicData } from '../../data/game/datapash/IDynamicData';
var GamePlayModel = (function (_super) {
    __extends(GamePlayModel, _super);
    function GamePlayModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GamePlayModel.prototype.update = function () {
        this.dynamics = [];
        this.allDynamics = [];
        this.datapashCount = 0;
    };
    /**
     * 是否达到阶段提交的条件
     */
    GamePlayModel.prototype.checkDatapash = function (score) {
        var interfaceLimit = DataManager_1.DataManager.ins.gameCfgData.defenseStrategy.interfaceLimit || 50;
        var scoreUnit = DataManager_1.DataManager.ins.gameCfgData.defenseStrategy.scoreUnit;
        var nextDatapashScore = score - this.datapashCount * scoreUnit;
        if (nextDatapashScore >= scoreUnit && this.datapashCount < interfaceLimit) {
            return true;
        }
        return false;
    };
    /**
     * 阶段提交
     * @param net
     */
    GamePlayModel.prototype.datapash = function () {
        var dynamicStr = JSON.stringify(this.dynamics);
        this.allDynamics.push(this.dynamics);
        this.datapashData(null, dynamicStr);
        this.dynamics = [];
        this.datapashCount++;
    };
    /**
     * 添加防作弊数据
     * @param dynamic
     */
    GamePlayModel.prototype.addDynamic = function (dynamic) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        this.dynamics.push(dynamic);
    };
    /**
     * 缓存最高分
     */
    GamePlayModel.prototype.cacheMaxScore = function (score) {
        //将最高纪录缓存
        var maxScore = GMath_1.GMath.int(GCache_1.GCache.readCache("maxScore"));
        if (!maxScore) {
            maxScore = 0;
        }
        maxScore = Math.max(maxScore, score);
        GCache_1.GCache.writeCache('maxScore', maxScore);
    };
    /**
     * 复活操作
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id
     */
    GamePlayModel.prototype.doRevive = function (callback, collectRuleId, itemId) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager_1.NetManager.ins.doRevive(function (success) {
            callback(success);
        }, collectRuleId, itemId);
    };
    /**
     * 获得复活次数
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id
     */
    GamePlayModel.prototype.getReviveCardNum = function (callback, collectRuleId, itemId) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager_1.NetManager.ins.getReviveCardNum(function (success) {
            callback(success);
        }, collectRuleId, itemId);
    };
    /**
     * 提交游戏成绩
     * @param callback
     * @param score 得分
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机
     */
    GamePlayModel.prototype.submit = function (callback, score, checkScore, customizedType) {
        this.allDynamics.push(this.dynamics);
        this.gameSubmitData(callback, score, this.allDynamics, checkScore, customizedType);
        this.dynamics = [];
    };
    Object.defineProperty(GamePlayModel.prototype, "gameIsWinning", {
        /**
         * 游戏结束弹窗
         */
        get: function () {
            return DataManager_1.DataManager.ins.gameGetSubmitResultData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    return GamePlayModel;
}(GameModel_1.GameModel));
exports.GamePlayModel = GamePlayModel;
__reflect(GamePlayModel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/libs/tw/model/game/GamePlayModel\".GamePlayModel");
//# sourceMappingURL=GamePlayModel.js.map