"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var ActivityModel_1 = require("./ActivityModel");
var NetManager_1 = require("../../manager/NetManager");
var DataManager_1 = require("../../manager/DataManager");
/**
 * 自定义活动工具业务模型
 */
var CustomModel = (function (_super) {
    __extends(CustomModel, _super);
    function CustomModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 抽奖
     * @param callback
     * @param nextStep 下一步做什么，轮询结果或者前置开奖等
     */
    CustomModel.prototype.customDoJoin = function (callback, nextStep, collectRuleId) {
        if (window['uid'] == 'not_login') {
            window['requirelogin']();
            return;
        }
        NetManager_1.NetManager.ins.doJoin(function (success) {
            if (nextStep && success) {
                nextStep(callback);
            }
            else {
                callback(success);
            }
        }, collectRuleId);
    };
    /**
     * 获取活动工具抽奖结果
     * @param callback
     */
    CustomModel.prototype.getCustomOrderStatus = function (callback) {
        NetManager_1.NetManager.ins.getCustomOrderStatus(callback, DataManager_1.DataManager.ins.doJoinData.orderId, function () {
            return DataManager_1.DataManager.ins.getCustomOrderStatusData.result == 0;
        });
    };
    /**
     * 获取前置开奖信息
     * @param callback
     */
    CustomModel.prototype.getOrderInfo = function (callback) {
        NetManager_1.NetManager.ins.getOrderInfo(callback, DataManager_1.DataManager.ins.doJoinData.orderId);
    };
    /**
     * 前置抽奖提交
     * @param callback
     */
    CustomModel.prototype.beforSubmit = function (callback) {
        var _this = this;
        NetManager_1.NetManager.ins.beforSubmit(function (success) {
            if (success) {
                _this.getCustomOrderStatus(callback);
            }
            else {
                callback(success);
            }
        }, DataManager_1.DataManager.ins.doJoinData.orderId, DataManager_1.DataManager.ins.getOrderInfoData.facePrice);
    };
    /**
     * 闯关游戏提交
     * @param callback
     */
    CustomModel.prototype.throughSubmit = function (callback) {
        NetManager_1.NetManager.ins.throughSubmit(callback, DataManager_1.DataManager.ins.doJoinData.orderId);
    };
    Object.defineProperty(CustomModel.prototype, "customIsWinning", {
        /**
         * 活动工具是否中奖
         */
        get: function () {
            return DataManager_1.DataManager.ins.getCustomOrderStatusData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    return CustomModel;
}(ActivityModel_1.ActivityModel));
exports.CustomModel = CustomModel;
__reflect(CustomModel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/libs/tw/model/common/CustomModel\".CustomModel");
//# sourceMappingURL=CustomModel.js.map