## 安装和更新构建工具
重新拉取代码，然后安装依赖。
```bash
git pull && cnpm install
```

## 启动本地服务器
```bash
npm run dev
```
之后会自动打开浏览器。建议在vscode中f5调试，效率更高。

## 发布
### 全发布
```bash
npm run build 
```
### 仅仅发布src下的TS代码
```bash
npm run buildTS
```
之后只需要更新皮肤中的`output.js`文件的版本号
```html
<script crossorigin="anonymous" src="//yun.duiba.com.cn/db_games/activity/demo/1537173012/output.js"></script>
```
### 仅仅发布exmls文件
```bash
npm run buildExml 
```
之后只需要更新皮肤中的`default.thm.js`文件的版本号
```html
<script crossorigin="anonymous" src="//yun.duiba.com.cn/db_games/activity/demo/1537172754/r"></script>
```

## demo
- demo皮肤 https://mng.duiba.com.cn/DuibaNgameBrick/edit/476
- demo线上url http://activity-2.m.duiba.com.cn/ngame/index?id=3122353&dbnewopen&dpm=1.5.677.4&dcm=202.3122353.4.677

## 项目结构介绍
### .vscode
vscode调试配置文件，需要提前安装chrome debugger插件。
### egret 
egret相关根目录。特别说明：暂时无法把其中文件放到根目录，后续优化。
- bin-release 发布文件目录，oss提交根目录
- libs库文件夹
- resource对应egret的resource
- scripts为发布相关脚本
- src源码目录。
- template勿删。
- autoMerger.js生成图集合并的项目配置文件。
- egretProperties.json，egret项目配置
- index.html，入口文件。
- project.json，同以前，后续考虑优化掉。
- publish.js oss发布文件。
- tsconfig.json ，ts配置。
- wingProperties.json，egret wing配置。

### mock
mock配置，同以前。
### .buildrc.js
构建配置
### .npmrc
npm源配置。
### build.js
构建脚本。

## 说明
### 自动化图集合并说明
不会合并组内的jpg。一般jpg都是外部加载，合入png图集，会显著增加png图集的体积

## 未来
- 增加webp支持，提升载入速度。
- 基于asm的mock api
- 更快的编译（优化devtool）
- 更高效的研发：引入HRM

## 背景
尽量保持以往的开发习惯，减少工作流的环节变更，减少迁移引擎导致的成本

## 优势
- 一键发布
- 自动化编译，极快的编译速度，极致的开发效率。抛弃了egret build，因为它非常的慢，空项目编译2秒，项目代码越多编译越慢，而且还需要手动编译。
- 非常快的首屏载入速度。合并了所有egret相关库为单独一个文件 //yun.duiba.com.cn/db_games/lib2_game.min.js，抛弃了非常慢的基于manifest的串行加载。（egert p2.js cdn  //yun.duiba.com.cn/db_games/physics.min.js）
- tinypng图片压缩由手动升级为自动，大大提升研发效率
- 自动化合并图集。开发阶段不需要合并图集，大大提升开发效率。
- 修改exmls等其他项目文件后自动刷新浏览，进一步提升研发效率。
- 0成本迁移tc和tw（无需要修改代码）
- 0成本迁移mock
- 暂不使用egret的网络通讯库，仍然使用zepto（有空优化）
- 其他无成本迁移的开发习惯，比如自动编译、自动刷新浏览器、编辑器vscode、webstorm习惯等。
- 项目初始化简化：现在依赖只需要安装一次，不需要每个项目都安装一次。移除了project.json。
- 和其他egret工具、流程兼容，比如exml编辑器egret wing。
- 以前一个皮就是一个项目。现在只有一个vscode项目，方便管理项目。
- 使用新的git流，可以有效的减少整个仓库的体积，几十上百个项目，其实有用的不多
- 相对以前发布速度极快。只有代码变更的时候，只需要编译ts发布，只有exmls文件变更的时候，只发布exmls，大大节省了发布时间。
- 现在代码里有基本的panel，scene，loading可以参考一下，后续会独立成类似tl、wx的库

## 项目创建和维护流程

1.先建立一个分支
```bash
git checkout -b kickball-20180910
```

2.然后duiba-games下直接创建【项目名称】的文件夹kickball-20180910


3.push分支到远程
```bash
git push --set-upstream origin kickball-20180910
```
4.然后在分支下开发，如果是新类型游戏，将来可能需要换皮的，那么备份到backup下。移动 kickball-20180910到backup。


5.然后合并到主分支。

```bash
git checkout dev

git merge kickball-20180910

git push
```


6、因为已经backup，所以这个分支已经没用了，删除分支

```bash
git branch -D kickball-20180910

git push origin :kickball-20180910
```

如果不需backup后面要维护，那么留着分支，不必合并到主分支。这样可以避免频繁提交导致的频繁git pull，提升效率。