import { getSkinPath } from "../utils";
import { btnDelay } from "../comm/UtilsConst";

export default class Bar extends eui.Component {
    public share:eui.Group;
    public title:eui.Label;
    public back:eui.Group;

    private data = null;

    constructor(data?) {
        super();
        this.skinName = getSkinPath('Component/Bar');
        this.data = data || null;

        this.initEvents();
        this.title.text = document.title;//'工行卡中心';
    }

    private initEvents() {
        this.back.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.share.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    /// TODO 定义详细的操作
    private onTap(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch(e.target) {
            case this.share: // 分享
                window['share']();
                break;

            case this.back: // 返回
                window.history.back();
                break;
            default:
                break;
        }
    }
}
