import Panel from "../views/Panel";
import { btnDelay } from "../comm/UtilsConst";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";

export default class ExchangedPanel extends Panel {
    public closeBtn: eui.Button;
    public btn: eui.Image;
    public title: eui.Label;
    public record: eui.Image;
    public prizeImg: eui.Image;

    exd_suc_bg: eui.Image;
    exd_fail_bg: eui.Image;
    btn1:eui.Image;

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTap, this],
            [this.record, this.onTap, this],
            [this.btn1, this.onTap, this],
        ])
    }

    private onTap(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch (e.target) {
            case this.btn:
                window.location.href = window['record'];
                this.onTouchClose();
                break;
            case this.record:
                window.location.href = window['record'];
                break;
            case this.btn1:
                this.onTouchClose();
                break;

            default:
                break;
        }
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        NetManager.ins.queryPrizeInfo((success, res) => {
            if (!success) {
                return;
            }

            const data = res.data[0];
            let _v = this.data.type == "success";
            this.exd_suc_bg.visible = _v;
            this.exd_fail_bg.visible = !_v;
            this.btn.visible = _v;
            this.btn1.visible = !_v;

            this.title.text = data.name;
            let title = data.name.split('_@_');
            this.title.text = title[0];
            this.prizeImg.source = data.icon;
        }, this.data.prizeId);
        GDispatcher.dispatchEvent('shopUpdate');
        
    }

    destroy() {
        super.destroy();
    }

    public get skinKey() {
        return 'ExchangedPanel'
    }

    public get groupName() {
        return 'exchanged_panel'
    }

}
