"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var TopLayerCtrl = (function () {
    function TopLayerCtrl() {
        this.canvasH = 750 / window.innerWidth * window.innerHeight;
        this.canvasW = 750 / window.innerWidth * window.innerWidth;
    }
    Object.defineProperty(TopLayerCtrl, "instance", {
        get: function () {
            return TopLayerCtrl._instance || (TopLayerCtrl._instance = new TopLayerCtrl());
        },
        enumerable: true,
        configurable: true
    });
    TopLayerCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    TopLayerCtrl.prototype.show = function (type, data, maskAlpha) {
        if (maskAlpha === void 0) { maskAlpha = 0; }
        if (this._current) {
            this.remove(this._current);
            // this._current = null;
        }
        this.addMask(maskAlpha);
        this._parent.visible = true;
        var cls = this._panelClassMap[type];
        Loading_1.default.instace.show();
        var panel = new cls(data);
        this._current = panel;
        this.add(panel);
    };
    /**
     * 加入黑色蒙层
     */
    TopLayerCtrl.prototype.addMask = function (maskAlpha) {
        /// TODO 临时改造，将生成的mask alpha 设置为 1，使用生成后的Sprite来设置透明度，比免重复的移除和生成
        if (!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, 1);
            this._mask.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = maskAlpha;
        this._parent.addChild(this._mask);
    };
    /**
     * 移除蒙层
     */
    TopLayerCtrl.prototype.removeMask = function () {
        /// TODO 不知道谁干的。 暂时认为没必要移除，且移除易造成_mask不是_parent的子渲染项
        // if(this._mask) {
        // this._parent.removeChild(this._mask);
        // }
        this._parent.visible = false;
    };
    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    TopLayerCtrl.prototype.btnDelay = function (targe, dtime) {
        if (dtime === void 0) { dtime = 500; }
        targe.touchEnabled = false;
        setTimeout(function () {
            targe.touchEnabled = true;
        }, dtime);
    };
    TopLayerCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.onShowAnim();
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    TopLayerCtrl.prototype.remove = function (panel) {
        this._current && this._current.destroy();
        this._current = null;
        panel.parent && this._parent.removeChild(panel);
    };
    TopLayerCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.removeMask();
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    TopLayerCtrl.prototype.panelHide = function (panel) {
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    TopLayerCtrl.prototype.registerPanelClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    TopLayerCtrl.prototype.registerPanels = function (panels) {
        var _this = this;
        panels.forEach(function (v) { return _this.registerPanelClass(v[0], v[1]); });
    };
    TopLayerCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    return TopLayerCtrl;
}());
exports.default = TopLayerCtrl;
__reflect(TopLayerCtrl.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/ctrls/topLayerCtrl\".TopLayerCtrl");
//# sourceMappingURL=topLayerCtrl.js.map