"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var Home_1 = require("../Scenes/Home");
var UtilsConst_1 = require("../comm/UtilsConst");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var ExchangePanel = (function (_super) {
    __extends(ExchangePanel, _super);
    function ExchangePanel(data) {
        return _super.call(this, data) || this;
    }
    ExchangePanel.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    ExchangePanel.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.btn, this.onTap, this],
        ]);
    };
    ExchangePanel.prototype.onTap = function () {
        UtilsConst_1.btnDelay(this.btn);
        if (this.data.stock <= 0) {
            UtilsConst_1.showToast('商品无库存，耐心等待商品补货后再来吧');
            return;
        }
        if (!this.canGet()) {
            UtilsConst_1.showToast('啊哦，合成所需食材不足，快去赚食材吧');
            return;
        }
        NetManager_1.NetManager.ins.prizeExchange(function (success, res) {
            if (!success) {
                UtilsConst_1.showToast('啊哦...目前无法兑换哦');
                return;
            }
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EXCHANGED_PANEL, res.data);
        }, this.data.strategyId);
    };
    ExchangePanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    ExchangePanel.prototype.initUI = function () {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        this.titleImg.mask = this.titleMask;
        this.titleImg.source = this.data.icon;
        // console.log(this.data);
        var title = this.data.name.split('_@_');
        // title[1].length >= 18 ? title[1] = title[1].slice(0, 17) + '\n' + title[1].slice(17) : 0;
        this.title.text = title[0];
        this.introduce.text = "\u5546\u54C1\u4ECB\u7ECD\uFF1A" + (title[1] || '无');
        this.stock.text = "\u5269\u4F59\u6570\u91CF\uFF1A" + this.data.stock;
        this.setNeed();
        this.setBtn();
    };
    ExchangePanel.prototype.setBtn = function () {
        var _this = this;
        this.canGet().then(function (res) {
            _this.btn.source = 'ex_btn_png';
            _this.btn.touchEnabled = true;
        }, function (err) {
            _this.btn.source = err;
            _this.btn.touchEnabled = false;
        });
    };
    ExchangePanel.prototype.canGet = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            // NetManager.ins.strategyRecords((success, res) => {
            //     if(success && res.data.length >= 1) {   // 已经合成过了，不能合成
            //         reject('ex_btn_done_png');
            //         return;
            //     }
            var showList = [];
            for (var spk in _this.data['spMap']) {
                showList.push(spk);
            }
            var products = Home_1.G_GetHomeDataByKey(Home_1.HOME.PRODUCT);
            for (var _i = 0, showList_1 = showList; _i < showList_1.length; _i++) {
                var v = showList_1[_i];
                if (_this.data['spMap'][v] > products[v]) {
                    reject('ex_btn_dis_png');
                    return;
                }
            }
            resolve(true); // 以上都没有，可以合成
            // return;
            // }, this.data.strategyId, 5);
        });
    };
    // 显示需要的道具
    ExchangePanel.prototype.setNeed = function () {
        var _this = this;
        var showList = [];
        for (var spk in this.data['spMap']) {
            showList.push(spk);
        }
        // 设置道具下的label
        this.propGroup.width = 38 + 80 * (showList.length - 1);
        var products = Home_1.G_GetHomeDataByKey(Home_1.HOME.PRODUCT);
        showList.forEach(function (v, i) {
            _this[v + "_group"].visible = true;
            _this[v + "_group"].x = 80 * i;
            _this[v + "_label"].textFlow = [
                {
                    text: products[v].toString(),
                    style: { "textColor": (products[v] < _this.data['spMap'][v]) ? 0xed3330 : 0xffffff }
                },
                { text: '/' + _this.data['spMap'][v], style: { "textColor": 0xffffff } }
            ];
        });
        // 显示+号
        for (var i = 1; i < showList.length; i++) {
            this["add" + i].visible = true;
        }
    };
    ExchangePanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(ExchangePanel.prototype, "skinKey", {
        get: function () {
            return 'ExchangePanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ExchangePanel.prototype, "groupName", {
        get: function () {
            return 'exchange_panel';
        },
        enumerable: true,
        configurable: true
    });
    return ExchangePanel;
}(Panel_1.default));
exports.default = ExchangePanel;
__reflect(ExchangePanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/ExchangePanel\".ExchangePanel");
//# sourceMappingURL=ExchangePanel.js.map