"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("./../libs/tw/manager/NetManager");
var DataManager_1 = require("./../libs/tw/manager/DataManager");
/**
 * 接口常量
 *
 * 普通游戏接口
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/ngameSubmit
 * hdtool/recon/getOrderStatus
 *
 * 游戏支持复活 调用接口说明
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId
 *
 * 复活流程
 * hdtool/recon/ngame/resurrection 游戏复活接口 参数dojion中orderId 返回 复活id
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId，复活id 返回 复活状态 剩余复活次数 下一次复活所需积分（轮询）
 *
 * 多次领奖流程
 * hdtool/recon/ngame/ngameManySubmit 游戏多次发奖接口 参数dojion中orderId 返回多次领奖orderId
 * hdtool/recon/getOrderStatus 参数多次领奖返回的orderId
 */
var NetConst = (function () {
    function NetConst() {
    }
    NetConst.ajaxElement = function (callback) {
        var net = {
            name: 'gameAjaxElement',
            uri: '/hdtool/recon/ajaxElement',
            type: 'get',
            dataType: 'json',
            param: {
                duibaId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                activityId: DataManager_1.DataManager.ins.customCfgData.actId
            },
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 获取排行榜列表
     * @param callback 回调
     * @param rankId 排行榜id
     * @param activityId cfg oaid
     * @param needPreviousPeriod 是否需要上期排行榜数据
     * @param pageNo
     * @param pageSize
     */
    NetConst.recentRankList = function (callback, rankId, activityId, needPreviousPeriod, pageNo, pageSize) {
        if (needPreviousPeriod === void 0) { needPreviousPeriod = false; }
        if (pageNo === void 0) { pageNo = 0; }
        if (pageSize === void 0) { pageSize = 50; }
        var param = {
            rankId: rankId,
            activityId: activityId,
            needPreviousPeriod: needPreviousPeriod,
            pageNo: pageNo,
            pageSize: pageSize
        };
        var net = {
            name: 'recentRankList',
            uri: '/hdtool/rank/recentRankListNew',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 参与游戏
     * @param callback 回调
     * @param credits 积分
     * @param collectRuleId 集卡规则id？
     */
    NetConst.doJoin = function (callback, activityId, credits, collectRuleId) {
        if (activityId === void 0) { activityId = DataManager_1.DataManager.ins.customCfgData.actId; }
        var param = {
            activityId: activityId,
            activityType: 'hdtool',
            consumerId: DataManager_1.DataManager.ins.customCfgData.consumerId
        };
        if (credits) {
            param.credits = credits;
        }
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        var net = {
            name: 'doJoin',
            uri: '/hdtool/recon/doJoin',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.getToken(net);
    };
    /**
     * 轮询开始状态
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.getNgameStartStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'getNgameStartStatus',
            uri: '/hdtool/recon/ngame/getNgameStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 发送得分
     * @param callback 回调
     * @param orderId 订单id
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     */
    NetConst.ngameSubmit = function (callback, orderId, score, gameData, dynamicData, submitToken, rankId) {
        var sign = NetManager_1.NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        var param = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        var net = {
            name: 'ngameSubmit',
            uri: '/hdtool/recon/ngame/ngameSubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 游戏多次领奖
     * @param callback 回调
     * @param orderId 订单号
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     * @param rankId 排行id
     */
    NetConst.ngameManySubmit = function (callback, orderId, score, gameData, dynamicData, submitToken, rankId) {
        var sign = NetManager_1.NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        var param = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        var net = {
            name: 'ngameManySubmit',
            uri: '/hdtool/recon/ngame/ngameManySubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 游戏数据校验防作弊
     * @param callback 回调
     * @param orderId 订单id
     * @param dynamicData 动态数据
     * @param duibaId duiba活动id
     */
    NetConst.datapash = function (callback, orderId, dynamicData) {
        var param = {
            orderId: orderId,
            dynamicData: dynamicData,
            duibaId: window['CFG'].hdToolId
        };
        var net = {
            name: 'datapash',
            uri: '/hdtool/recon/ngame/datapash',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 复活接口
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.resurrection = function (callback, orderId) {
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'resurrection',
            uri: '/hdtool/recon/ngame/resurrection',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 轮询复活状态
     * @param callback 回调
     * @param orderId 订单id
     * @param pollingCheck 轮询条件
     * @param pollingCount 轮询次数
     * @param resurrecOrderId 复活订单id
     */
    NetConst.resurrectionStatus = function (callback, orderId, pollingCheck, pollingCount, resurrecOrderId) {
        if (pollingCount === void 0) { pollingCount = 10; }
        if (resurrecOrderId === void 0) { resurrecOrderId = -1; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'resurrectionStatus',
            uri: '/hdtool/recon/ngame/resurrectionStatus',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        if (resurrecOrderId != -1) {
            net.param.resurrecOrderId = resurrecOrderId;
        }
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 轮询订单状态
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.getOrderStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'getOrderStatus',
            uri: '/hdtool/recon/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 招商银行钓龙虾定制接口
     * @param callback 回调
     * @param activityId 活动id cfg oaid
     * @param score 分数
     * @param shareCode 分享码
     */
    NetConst.shrimpFishingIndex = function (callback, activityId, score, shareCode) {
        var param = {
            activityId: activityId
        };
        if (score) {
            param.score = score;
        }
        if (shareCode) {
            param.shareCode = shareCode;
        }
        var net = {
            name: 'shrimpFishingIndex',
            uri: '/aaw/changshaCmb/shrimpFishing/index',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 活动中奖名单轮播信息
     * @param callback 回调
     * @param id 活动id 支持多id以逗号符分割
     * @param type 查询类型 0：入库活动（自定义活动工具、新活动工具） 1：插件活动 2、集卡
     * @param count 期望获取数量 默认100
     */
    NetConst.winners = function (callback, id, type, count) {
        if (count === void 0) { count = 100; }
        var param = {
            id: id,
            type: type,
            count: count
        };
        var net = {
            name: 'winners',
            uri: '/activity_winner/winners',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 开发者任务列表查询
     * @param callback 回调
     * 返回的主要参数说明：
     * status 任务状态： 任务完成状态，去完成（false），待领奖（process），已领奖（success）
     * credits 用户完成任务可获得的积分
     */
    NetConst.queryTaskList = function (callback) {
        var param = {};
        var net = {
            name: 'queryTaskList',
            uri: '/customActivity/task/queryTaskList',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 养成签到
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
         * 获取多宠物列表
         * @param callback
         * @param activityId
         */
    NetConst.getPetsInfo = function (callback, activityId) {
        var net = {
            name: 'getPetsInfo',
            uri: '/signpet/getPetsInfo',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: activityId
            },
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 集卡
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/
    /**
     * 用户集卡信息及奖项
     * @param callback
     * @param collectRuleId
     */
    NetConst.getCollectRule = function (callback, collectRuleId) {
        var net = {
            name: 'getCollectRule',
            uri: '/plugin/collectRule/getCollectRule',
            type: 'get',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId
            },
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 定制接口
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * 海底捞收获锅底
     * @param callback 回调
     * @param petId 宠物id
     * @param activityId 活动id
     */
    NetConst.collectSoup = function (callback, petId, activityId) {
        var param = {
            petId: petId,
            activityId: activityId
        };
        var net = {
            name: 'collectSoup',
            uri: '/customActivity/haidilao/signpet/takePrize',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
         * 海底捞火锅加热
         * @param callback 回调
         * @param petId 宠物id
         * @param activityId 活动id
         */
    NetConst.heatSoup = function (callback, petId, activityId) {
        var param = {
            petId: petId,
            activityId: activityId
        };
        var net = {
            name: 'heatSoup',
            uri: '/customActivity/haidilao/signpet/feed',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 海底捞火锅养成任务领奖
     * @param callback 回调
     * @param petId 任务id
     * @param activityId 活动id
     */
    NetConst.takePrize = function (callback, taskId, activityId) {
        var param = {
            taskId: taskId,
            activityId: activityId
        };
        var net = {
            name: 'takePrize',
            uri: '/customActivity/haidilao/signpet/task/takePrize',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
    * 获取书旗叠小七排行榜列表
    * @param callback 回调
    * @param activityId 活动工具id
    */
    NetConst.getRankList = function (callback, activityId) {
        var param = {
            activityId: activityId
        };
        var net = {
            name: 'rankList',
            uri: '/customActivity/shuqi/pet/rankList',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 我的萌宠列表接口
     * @param callback 回调
     * @param actId 活动id
     */
    NetConst.myPetsList = function (callback, actId) {
        var param = {
            activityId: actId
        };
        var net = {
            name: 'myPetsList',
            uri: '/customActivity/shuqi/pet/myList',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 召唤萌宠列表接口
     * @param callback 回调
     * @param actId 活动id
     */
    NetConst.callPetsList = function (callback, actId) {
        var param = {
            activityId: actId
        };
        var net = {
            name: 'callPetsList',
            uri: '/customActivity/shuqi/pet/callList',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    return NetConst;
}());
exports.default = NetConst;
__reflect(NetConst.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/NetConst\".NetConst");
//# sourceMappingURL=NetConst.js.map