import { Data } from "../Data";

export class GetSignResultData extends Data {
    /**
     * 积分余额
     */
    public totalCredits:string;
    /**
     * 	加积分数量
     */
    public addCredits:string;
    /**
     * 加活动次数总量	
     */
    public addActivityCount:string;
    /**
     * 加活动次数状态 0处理中 1失败 2成功
     */
    public activityCountStatus:string;
    /**
     * 加积分状态 0处理中 1失败 2成功
     */
    public creditsStatus:string;
    /**
     * 抽奖次数奖励信息{奖励类型：奖励数量}
     */
    public activityCountMsg:any;
    /**
     * 积分奖励信息{奖励类型：奖励数量}
     */
    public creditsMsg:any;
    /**
     * 签到状态
     */
    public status:any;
    /**
     * 奖励集合
     */
    public rewardMap:any;


    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);

        if(result.totalCredits){
            this.totalCredits = result.totalCredits;
        }
        if(result.addCredits){
            this.addCredits = result.addCredits;
        }
        if(result.addActivityCount){
            this.addActivityCount = result.addActivityCount;
        }
        if(result.activityCountStatus){
            this.activityCountStatus = result.activityCountStatus;
        }
        if(result.activityCountMsg){
            this.activityCountMsg = result.activityCountMsg;
        }
        if(result.creditsMsg){
            this.creditsMsg = result.creditsMsg;
        }
        if(result.status){
            this.status = result.status;
        }
        if(result.rewardMap){
            this.rewardMap = result.rewardMap;
        }
    }
}