import { gameconfig } from "./gameconst";

export const clearCurrentScore = () => {
    localStorage.setItem('currentScore', '0')
}

export const addCurrentScore = () => {
    let score = getCurrentScore();
    score++;
    localStorage.setItem('currentScore', score + '')
}

export const getCurrentScore = () => {
    const data = localStorage.getItem('currentScore')
    if (!data)
        return 0
    return parseInt(data)
}

export const getCurrentPercent = () => {
    return getCurrentScore() /   gameconfig.max;
}

export const getCurrentItems = () => {
    return gameconfig.items
}