import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import { ExChangeItem } from '../ui/ExChangeItem';
import { RunAni } from '../panels/RunAni';
import { LeavesAni } from '../panels/LeavesAni';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
export default class StartScene1 extends Scene {
    public ruleBtn:eui.Button;
    public signBtn:eui.Button;
    public itemGroup:eui.Group;
    public prizeBtn:eui.Button;
    public startBtn:eui.Button;

    public myMoneyLb:eui.Label;
    public signDayLb:eui.Label;
    public taskTipsLb:eui.Label;

    public smartparkingLb:eui.Label;
    public repaymentLb:eui.Label;
    public paymentLb:eui.Label;
    public mainGroup:eui.Group;

    public skip0:eui.Image;
    public skip1:eui.Image;

    public scorller:eui.Scroller;

    private mhItem:ExChangeItem;

    private roleMc:RunAni;

    private mcFactory:any;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        super.initEvents();
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.signBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_signBtn, this);
        this.skip0.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_skip0, this);
        this.skip1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_skip1, this);

        for (let i = 0; i < 7; i++) {
            this['dayGroup' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_dayGroup, this);
            this['dayGroup' + i].name = i;
        }

        for(let i = 0; i < 3; i++){
            this['getBtn' + i].name = i;
            this['getBtn' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getBtn, this);
            this['earnBtn' + i].name = i;
            this['earnBtn' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_earnBtn, this);
        }

        GDispatcher.addEvent('refreshMoney', this.refreshMoney, this);
        GDispatcher.addEvent('refreshMangheBtn', this.refreshMangheBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.signBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_signBtn, this);
        this.skip0.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_skip0, this);
        this.skip1.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_skip1, this);

        for (let i = 0; i < 7; i++) {
            this['dayGroup' + i].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_dayGroup, this)
        }

        for(let i = 0; i < 3; i++){
            this['getBtn' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getBtn, this);
            this['earnBtn' + i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_earnBtn, this);
        }
        GDispatcher.removeEvent('refreshMoney', this.refreshMoney);
        GDispatcher.removeEvent('refreshMangheBtn', this.refreshMangheBtn);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        // console.log('载背景并设置背景图片mainscene');

        await RES.loadGroup('runani');

        var mcJson = await RES.getResAsync('snowAct_json');
        var mcImg = await RES.getResAsync('snowAct_png');
        this.mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

		// setTimeout(() => {
		// 	let scrollHeight = document.documentElement.scrollTop || document.body.scrollTop || 0;
		// 	window.scrollTo(0, Math.max(scrollHeight - 1, 0));
		// }, 100);

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);


        startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);
        
        startDpmOut = Buried.connectDpm(110, 4, 2); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);
        
        startDpmOut = Buried.connectDpm(110, 4, 3); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);
        
        startDpmOut = Buried.connectDpm(110, 4, 4); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);


        startDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        startDpmOut = Buried.connectDpm(110, 14, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        // this.scorller.viewport.scrollV = 0;
        this.initUI();

        let str = window.location.href;
        console.log(11111111);
        // if(str.indexOf('?') == -1){
        //     if(str.indexOf('refreshwww') == -1){
        //         window.location.href = str + '?refreshwww=1'
        //         console.log(2222222);
        //     }
        // }else{
        //     if(str.indexOf('refreshwww') == -1){
        //         window.location.href = str + '&refreshwww=1'
        //         console.log(3333333);
        //     }

        // }
        // this.invalidateState();
        
    }

    private initUI(): void {
        //叶子
        // var bbb = new LeavesAni();
        // this.mainGroup.addChild(bbb);
        // bbb.play();

        //添加人物相关
        this.addRunAni();

        this.initData();

        //初始化雪花
        this.initSnow();

        //处理接口
        Loading.instace.show();
        //设置兑换奖品
        NetManager.ins.getProjectData((success)=>{
            if(!success){
                PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                Loading.instace.hide();
                return;
            }
            console.log('getProjectDatasuccess',success);
            let projectArr = DataManager.ins.getData(NetName.GET_PROJECT_DATA).data;
            DataManager.ins.getGameInfoData.projectArr = projectArr;
            if(projectArr && projectArr.length){
                for(let i = 0; i < projectArr.length; i++){
                    let pItem = new ExChangeItem((data, item)=>{
                        //点击兑换按钮
                        console.log('点击兑换按钮');

                        if(data.needAmount > DataManager.ins.getGameInfoData.totalAmount){
                            //雪花不足
                            PanelCtrl.instance.show(ModuleTypes.NOREDMAPLE_PANEL);

                        }else{
                            if(data.sufficient){
                                PanelCtrl.instance.show(ModuleTypes.LOTBOX_PANEL, {
                                    needAmount:data.needAmount,
                                    blackBoxFlag:data.blackBoxFlag,
                                    prizeId:data.prizeId,
                                    icon:data.icon,
                                    name:data.name,
                                    item:item
                                });
                                // if(data.blackBoxFlag){
                                //     //如果是盲盒
                                // }else{
                                //     Loading.instace.show();
                                //     NetManager.ins.exchangeProject((success)=>{
                                //         if(success){
                                //             PanelCtrl.instance.show(ModuleTypes.EXCHANGESUC_PANEL);
                                //             item.exchangeBtn.currentState = 'disabled';
                                //             item.exchangeBtn.touchEnabled = false;
                                //             this.refreshMoney();
                                //         }else{
                                //             PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                                //             Loading.instace.hide();
                                //         }
                                //         Loading.instace.hide();
                                //     }, data.prizeId);
                                // }
                            }else{
                                //库存不充足弹未中奖
                                PanelCtrl.instance.show(ModuleTypes.OUTOFPRIZE_PANEL);
                            }
                        }
                        
                    });

                    let data = projectArr[i];

                    if(data.blackBoxFlag){
                        this.mhItem = pItem;
                    }
                    pItem.pData = data;
                    pItem.name = i + '';

                    if(pItem.itemImg){
                        pItem.itemImg.source = data.icon;
                    }
                    pItem.itemValue.text = data.needAmount + ' 雪花';
                    let pname = data.name;
                    if(pname.length > 7){
                        pname = pname.substr(0, 6) + '…';
                    }
                    pItem.itemNameLb.text = pname;
                    console.log('pname',pname)

                    if(data.exchangeFlag){
                        pItem.exchangeBtn.currentState = 'disabled';
                        pItem.exchangeBtn.touchEnabled = false;
                    }else{
                        pItem.exchangeBtn.currentState = '';
                        pItem.exchangeBtn.touchEnabled = true;
                    }

                    this.itemGroup.addChild(pItem);
                    pItem.x = i * 200;
                }

            }
        });

        //设置任务状态
        NetManager.ins.getTaskData((success)=>{
            if(!success){
                PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                Loading.instace.hide();
                return;
            }

            let taskData = DataManager.ins.getData(NetName.GET_TASK_DATA).data;
            DataManager.ins.getGameInfoData.taskData = taskData;

            this.taskTipsLb.text = '已完成：' + taskData.finishCnt + '/' + taskData.totalCnt;

            this.paymentLb.text         = '+' + taskData.payment.prizeAmount + '雪花';
            this.repaymentLb.text       = '+' + taskData.repayment.prizeAmount + '雪花';
            this.smartparkingLb.text    = '+' + taskData.smartparking.prizeAmount + '雪花';


            if(taskData.smartparking){
                this.setTaskBtn(taskData.smartparking.status, 0);
            }
            if(taskData.repayment){
                this.setTaskBtn(taskData.repayment.status, 1);
            }
            if(taskData.payment){
                this.setTaskBtn(taskData.payment.status, 2);
            }

            Loading.instace.hide();
        })

        PanelCtrl.instance.isLoseCoin = false;
    }

    private initSnow():void{
        for(let i = 0; i < 7; i++){
            let snowAct = new egret.MovieClip(this.mcFactory.generateMovieClipData());
            snowAct.x = 10;
            snowAct.play(-1);
            this['light' + i].addChild(snowAct);
        }
    }

    private addRunAni():void {
        this.roleMc = new RunAni();
        this.mainGroup.addChild(this.roleMc);
        this.roleMc.y = 35;
    }

    private setTaskBtn(status:number, bidx:number):void{
        switch(status){
            case 0:
                this['getBtn' + bidx].visible = false;
                this['earnBtn' + bidx].visible = true;

                if(bidx == 0){

                    let startDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);
                }else if(bidx == 1){

                    let startDpmOut = Buried.connectDpm(110, 5, 2); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);

                }else if(bidx == 2){

                    let startDpmOut = Buried.connectDpm(110, 5, 3); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);

                }

                break;
            case 1:
                this['getBtn' + bidx].visible       = true;
                this['earnBtn' + bidx].visible      = false;
                this['getBtn' + bidx].currentState = '';
                this['getBtn' + bidx].touchEnabled = true;

                if(bidx == 0){
                    let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);

                }else if(bidx == 1){
                    let startDpmOut = Buried.connectDpm(110, 6, 2); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);

                }else if(bidx == 2){
                    let startDpmOut = Buried.connectDpm(110, 6, 3); // 点击埋点   
                    let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    let exposure = Buried.createExposure(startDpmOut, startDcmOut);
            
                    NetManager.ins.showLog(exposure);

                }
                break;
            case 2:
                this['getBtn' + bidx].visible       = true;
                this['earnBtn' + bidx].visible      = false;
                this['getBtn' + bidx].currentState = 'disabled';
                this['getBtn' + bidx].touchEnabled = false;
                break;
        }
    }

    private initData(isPlay:boolean = false):void{
        this.myMoneyLb.text = '我的雪花:' + DataManager.ins.getGameInfoData.totalAmount;
        const serialDays = DataManager.ins.getGameInfoData.serialDays;
        let sDStr = '';
        if(serialDays > 99){
            sDStr = '99+'
        }else{
            sDStr = serialDays;
        }

        let currSign = DataManager.ins.getGameInfoData.todaySignFlag;
        if(currSign){
            this.signBtn.currentState   = 'disabled';
            this.signBtn.touchChildren  = false;
            this.signBtn.touchEnabled   = false;
        }else{
            this.signBtn.currentState   = '';
            this.signBtn.touchChildren  = true;
            this.signBtn.touchEnabled   = true;
        }
        this.signDayLb.text = '已经连续签到 ' + sDStr + ' 天';

        let cycleDays = DataManager.ins.getGameInfoData.cycleDays;
        this.setDayGroup(cycleDays);

        if(isPlay){
            if(cycleDays){
                console.log('cycleDays',cycleDays)
                this.roleMc.play(cycleDays, ()=>{
                    let light = this['light' + (cycleDays - 1)];
                    light.visible = true;
                    //1.0光效旋转动效
                    // egret.Tween.removeTweens(light);
                    // egret.Tween.get(light, {loop:true}).to({rotation:360}, 5000);
                    
                    let score1 = this['score' + (cycleDays - 1) + '1'];
                    let score2 = this['score' + (cycleDays - 1) + '2'];

                    score1.alpha = 0;
                    egret.Tween.get(score1).to({alpha:1}, 500);
                    egret.Tween.get(score2).to({alpha:0}, 500).call(()=>{
                        score1.alpha = 1;
                        score2.alpha = 1;

                        score1.visible = true;
                        score2.visible = false;
                    });

                    let sData = DataManager.ins.getData(NetName.SIGN).data;
                    setTimeout(() => {
                        PanelCtrl.instance.show(ModuleTypes.SIGNSUC_PANEL, {sData:sData});
                    }, 200);
                });
            }
        }else{
            this.roleMc.reset(cycleDays);
        }

        // if(cycleDays == 0){
        //     this.setDayGroup(0)
        // }else{
        //     this.setDayGroup(3);
        // }
    }

    //设置界面日期显示
    private setDayGroup(currIdx:number):void{this.touchEnabled
        for(let i = 0; i < 7; i++){
            if(i >= currIdx){
                this['sGroup' + i + '1'].visible = false;
                this['sGroup' + i + '2'].visible = true;
                this['dayGroup' + i].touchChildren = false;
                this['dayGroup' + i].touchEnabled = false;

                this['score' + i + '1'].visible = false;
                this['score' + i + '2'].visible = true;

                this['light' + i].visible = false;
            }else{
                this['sGroup' + i + '1'].visible = true;
                this['sGroup' + i + '2'].visible = false;
                this['dayGroup' + i].touchChildren = true;
                this['dayGroup' + i].touchEnabled = true;

                this['score' + i + '1'].visible = true;
                this['score' + i + '2'].visible = false;
                this['light' + i].visible = true;
            }


            let data = DataManager.ins.getGameInfoData.signPrizeAmountArr;
            if(i == 1 || i == 3 || i == 6){
                this['sLb' + i + '1'].text = '+' + data[i];
                this['sLb' + i + '2'].text = '+' + data[i];
            }else{
                this['score' + i + '1'].text = '+' + data[i];
                this['score' + i + '2'].text = '+' + data[i];
            }
        }
    }

    //领取雪花按钮
    private onTap_getBtn(e:egret.TouchEvent):void{
        let gbidx = e.currentTarget.name;
        let startDpmOut = Buried.connectDpm(110, 6, Number(gbidx) + 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);

        let taskCode;
        let tdata = DataManager.ins.getGameInfoData.taskData;
        let tinfo;

        switch(gbidx){
            case 0:
                taskCode = tdata.smartparking.code;
                tinfo = tdata.smartparking;
                break;
            case 1:
                taskCode = tdata.repayment.code;
                tinfo = tdata.repayment;
                break;
            case 2:
                taskCode = tdata.payment.code;
                tinfo = tdata.payment;
                break;
        }

        Loading.instace.show();
        NetManager.ins.getMoneyData((success)=>{
            if(success){
                let data = DataManager.ins.getData(NetName.GET_MONEY_DATA).data;
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'领取成功 +' + data.prizeAmount + '雪花'});
                console.log('tinfo',tinfo);
                tinfo.status = 2;
                this.setTaskBtn(tinfo.status, gbidx);

                this.refreshMoney();

            }else{
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常，领取失败！'});//????????
            }
            Loading.instace.hide();
        }, taskCode);
    }

    //跳转链接按钮
    private onTap_earnBtn(e:egret.TouchEvent):void{

        let idx = e.currentTarget.name;
        
        PanelCtrl.instance.btnDelay(this['getBtn' + e.currentTarget.name]);
        let startDpmOut = Buried.connectDpm(110, 5, Number(idx) + 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);
        let url;

        var u = navigator.userAgent;//, app = navigator.appVersion;
        var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g
        var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端

        if(idx == 0){
            url = window['url0'] ? window['url0'] : 'szbank://trans?isLogin=0|title=智慧停车|commercialId=100000000005|directUrl=http://www.bankofsz.com/becpChannel/web/main.html';
            setTimeout(() => {
                if (iphone) {
                    this.jumpTh(url); //智慧停车
                } 
                if (android){
                    this.jumpM(url); //安卓跳转
                }
            }, 200);

            
        }else if(idx == 1){
            url = window['url1'] ? window['url1'] : '/page/creditCard/payPromptly/main.html';
            this.jumpH(url);
        }else if(idx == 2){
            url = window['url2'] ? window['url2'] : '/page/lifeFees/lifeFees.html';
            this.jumpH(url);
        }
    }

    /**
     * 跳转第三方
     */
    private jumpTh(url):void {
        var param = {
          linktype: '05', // 跳转类型 01 跳转菜单 ; 02 跳转部分原生 ;03 跳转H5;04 跳转外部浏览器;05 跳转第三方页面;06 跳转TAB
          skipflag: '', // title
          skipaddr: url, // （不能为空）地址连接
          detailtype: ''
        };
        window['ThirdApp'].webViewJump(param);
    }

    private jumpM(url):void {
        var param = {
          linktype: '01', // 跳转类型 01 跳转菜单 ; 02 跳转部分原生 ;03 跳转H5;04
          // 跳转外部浏览器;05 跳转第三方页面;06 跳转TAB
          skipflag: '20180122', // 跳转标记 一级菜单 例：1004 信用卡
          skipaddr: '20180122', // 跳转地址 二级菜单 例：1070 信用卡申请
          detailtype: ''
        };
        window['ThirdApp'].webViewJump(param);
    }

    /**
     * 跳转部分H5
     */
    private jumpH(url):void {
        var param = {
          linktype: '03', // 跳转类型 01 跳转菜单 ; 02 跳转部分原生 ;03 跳转H5;04 跳转外部浏览器;05 跳转第三方页面;06 跳转TAB
          skipflag: '0', // 0:拼接服务器url !0:不拼接，直接加载传入的地址
          skipaddr: url, // （不能为空）地址连接
          detailtype: ''
        };
        // ThirdApp.webViewJump(param);
        // 修改新方案
        if (window['ThirdApp'].os == 'android') {
          // 关闭当前webview
          this.closeThirdPage();
          setTimeout(()=> {
            window['ThirdApp'].webViewJump(param);
          }, 800);
        } else {
            window['ThirdApp'].webViewJump(param);
          setTimeout(()=> {
            this.closeThirdPage();
          }, 800);
        }
    }

    /**
	  * 关闭第三方页面
    */
    private closeThirdPage():void{
        var param = {
          "finishType" : "0",// 关闭当前页    0不刷新    1刷新
        };
        window['ThirdApp'].colseViewPage(param);
    }

    //刷新雪花数
    private refreshMoney():void{
        NetManager.ins.consumerData((success) =>{
            if(!success){
                PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                Loading.instace.hide();
                console.log('consumerData defaild')
                return;
            }
            const data = DataManager.ins.getData(NetName.CONSUMER_DATA).data;
            DataManager.ins.getGameInfoData.totalAmount = DataManager.ins.getData(NetName.CONSUMER_DATA).data.totalAmount;

            this.myMoneyLb.text = '我的雪花:' + DataManager.ins.getGameInfoData.totalAmount;
        });
    }

    //设置盲盒按钮
    private refreshMangheBtn():void{
        if(this.mhItem){
            this.mhItem.exchangeBtn.currentState = 'disabled';
            this.mhItem.exchangeBtn.touchEnabled = false;
        }
    }

    private onClick_dayGroup(e:egret.TouchEvent):void{
        let idx = e.currentTarget.name;
        PanelCtrl.instance.btnDelay(this['dayGroup' + idx]);
        console.log('idx=' + idx);
        PanelCtrl.instance.show(ModuleTypes.SPOTINTRO_PANEL, {spotIndex:idx});
    }

    private onTap_ruleBtn(): void {

        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

        let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
    }


    private onTap_prizeBtn(): void {
        console.log('点击prizeBtn');
        PanelCtrl.instance.btnDelay(this.prizeBtn);//devhttp://activity.m.duibadev.com.cn/projectx/p274df766/fe1df32fa.html
        window.location.href = window['prizeUel'] ? window['prizeUel'] : 'http://activity.m.duibatest.com.cn/projectx/p0b7552ae/fe1df32fa.html';


        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
    }

    private notSign:boolean;
    private onTap_signBtn():void{
        // PanelCtrl.instance.btnDelay(this.signBtn);
        if(this.notSign){
            return;
        }

        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.signBtn.currentState = 'disabled'//fe1df32fa
        this.signBtn.touchEnabled = false;
        this.notSign = true;

        console.log('signBtn');
        NetManager.ins.sign((success)=>{
            if(success){

                this.refreshSignData();
                this.refreshMoney();

                // let sData = DataManager.ins.getData(NetName.SIGN).data;
                // setTimeout(() => {
                //     PanelCtrl.instance.show(ModuleTypes.SIGNSUC_PANEL, {sData:sData});
                // }, 500);
            }else{
                this.signBtn.touchEnabled = true;
                this.signBtn.currentState = '';

                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'网络异常！签到失败，请重试'});
            }
            this.notSign = false;
        });
    }

    //刷新签到数据
    private refreshSignData():void{
        NetManager.ins.getSignData((success)=>{
            if(!success){
                PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                Loading.instace.hide();
                console.log('getSignData defaild')
                return;
            }
            const data = DataManager.ins.getData(NetName.SIGN_DATA).data;

            let cycleDays = data.cycleDays;
            if(cycleDays == 8){
                DataManager.ins.getGameInfoData.cycleDays = 0;
                cycleDays = 0;
            }

            DataManager.ins.getGameInfoData.cycleDays       = cycleDays;
            DataManager.ins.getGameInfoData.serialDays      = data.serialDays;
            DataManager.ins.getGameInfoData.todaySignFlag   = data.todaySignFlag;
            DataManager.ins.getGameInfoData.signPrizeAmountArr      = data.signPrizeAmountArr;

            this.initData(true);

        });

    }

    private onTap_skip0():void{
        PanelCtrl.instance.btnDelay(this.skip0);
        window.location.href = window['skip0'] ? window['skip0'] : 'https://activity.m.duiba.com.cn/hdtool/index?id=3541627&banner'

        let startDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);
    }

    private onTap_skip1():void{
        PanelCtrl.instance.btnDelay(this.skip1);
        window.location.href = window['skip1'] ? window['skip1'] : 'https://activity.m.duiba.com.cn/hdtool/index?id=3691324&dbnewopen&banner'
        let startDpmOut = Buried.connectDpm(110, 14, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);
    }
    
    //获取我的奖品
    private gotoRecord(): string {
        let recordUrl: string;
        let oaId: number;
        // if (DataManager.ins.customCfgData) {
        //     oaId = DataManager.ins.customCfgData.oaId;
        //     recordUrl = DataManager.ins.customCfgData.recordUrl;
        // } else {
        //     oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
        //     recordUrl = window['recordUrl'];
        // }

        if (recordUrl.indexOf('?') != -1) {
            recordUrl += '&origins=' + oaId + '00';
        } else {
            recordUrl += '?origins=' + oaId + '00';
        }
        // recordUrl += ',' + (window['plugId'] ? window['plugId'] : 4500) + '01';

        // for(let i = 0; i < window['plugIdArr'].length; i++){
        //     recordUrl += ',' + window['plugIdArr'][i] + '01';
        // }

        return recordUrl;
    }


}
