import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";


const indexs = {
    1: 1,

}
const resources = [
    "wenhuazhongxin_png",
    "huqiuta_png",
    "tianpingshan_png",
    "hanshansi_png",
    "zhuozhengyuan_png",
    "tongdeli_png",
    "bowuguan_png",
]
const spotNames = [
    "文化中心",
    "虎丘塔",
    "天平山",
    "寒山寺",
    "拙政园",
    "同德里",
    "博物馆"
]

const intros = [
    '包括了苏州市文化馆、苏州美术馆、苏州市名人馆、吴作人艺术馆、苏州书法篆刻艺术院 颜文梁纪念馆（苏州油画院）、苏州版画院（苏州桃花坞年画博物馆）、苏州粉画艺术院（杭鸣时粉画艺术馆）、苏州公共艺术研究院等艺术场馆。其中，苏州市文化馆是文化部命名的国家一级文化馆，建有容纳557名观众的多功能剧场1座，容纳200人的学术报告厅3个，以及公共电子阅览室、舞蹈排练厅、琴房、培训教室、录音棚等公共文化设施。苏州美术馆建有面积800平方米的大展厅1个，面积300至400平方米的小展厅4个，1个恒温恒湿展厅、1个市民画廊以及121座多功能学术报告厅等一流设施。苏州市名人馆展陈面积1500平方米。以苏州历史名人、状元宰相和两院院士共计445人为展示对象。中心建有约2000平方米的文化广场，可开展各类公益性群众广场文化活动。',
    '虎丘塔是驰名中外的古塔建筑，位于江苏省苏州市阊门外山塘街虎丘山山门内8号，距市中心5公里。相传春秋时吴王夫差就葬其父（阖闾）于此，葬后3日，便有白虎踞于其上，故名虎丘山，简称虎丘。始建于五代后周显德六年（959年），落成于北宋建隆二年（961年）。塔七级八面，内外两层枋柱半拱，砖身木檐，是10世纪长江流域砖塔的代表作。由于宋代到清末曾遭到多次火灾，故顶部的木檐均遭毁坏，现塔身高47.7米。1956年在塔内发现大量文物，其中有越窑、莲花石龟等罕见的传统艺术珍品，虎丘塔是座斜塔。',
    '天平山以怪石、清泉、雪花“三绝”著称，山上奇石嶙峋，危耸峭峻，似封建时代大臣朝见皇帝用的附笏一样，人称“万笏朝天”山腰有钵盂泉，又名白云泉，泉水醇厚甘冽，相传茶圣陆羽品评为“吴中第一水”。山东南麓之古枫林，为明代万历年间宋代名臣范仲淹十七世孙范允临从福建带回，植于这祖茔之地。现存158棵，深秋时节，满山红叶若红霞缭绕，层层片片，蔚为壮大观，有“天平雪花甲天下”之誉，迄今已举办了四届雪花节，吸引了不少中外游客。',
    '寒山寺位于苏州市姑苏区，始建于南朝萧梁代天监年间（公元502～519年），初名“妙利普明塔院”。寒山寺占地面积约1.3万平方米，建筑面积三千四百余平方米。\n寒山寺属于禅宗中的临济宗。唐代贞观年间，当时的名僧寒山、希迁两位高僧创建寒山寺。1000多年内寒山寺先后5次遭到火毁（一说是7次），最后一次重建是清代光绪年间。历史上寒山寺曾是中国十大名寺之一，寺内古迹甚多，有张继诗的石刻碑文，寒山、拾得的石刻像，文徵明、唐寅所书碑文残片等。',
    '拙政园位于苏州城东北隅（东北街178号），截至2014年，仍是苏州存在的最大的古典园林，占地78亩（约合5.2公顷）。全园以水为中心，山水萦绕，厅榭精美，花木繁茂，具有浓郁的江南水乡特色。花园分为东、中、西三部分，东花园开阔疏朗，中花园是全园精华所在，西花园建筑精美，各具特色。园南为住宅区，体现典型江南地区传统民居多进的格局。园南还建有苏州园林博物馆，是一座园林专题博物馆。',
    '同德里位于言桥西南，同益里之北，东口隔五卅路与草桥弄相望，西端南通同益里。里长250米，宽2米，1985年改弹石路面为水泥道板路面。此处为旧时郡治后木兰堂遗址，《中吴纪闻》卷一：“木兰堂，多为太守燕游之地。范文正公作守时，尝赋诗云：‘堂上列歌钟，多惭不如古。却羡木兰花，曾见霓裳舞。’白乐天在苏，尝教倡人为此舞也。堂之前后，皆植木兰，干极高大，兵火后不存。”民国初年已为皇废基鱼塘，20世纪20年代北局建开明大戏院等建筑时，因推平高墩及开挖地基，将挖出的泥土填于此处。30年代上海闻人杜月笙在此建房出租，称同德里，含有“共沐德泽”之意。50年代后期起，改为苏州专署机关干部居住区。',
    '苏州博物馆新馆其特色体现在：建筑造型与所处环境自然融合，空间处理独特，建筑材料考究和内部构思，及最大限度地把自然光线引入到室内。\n在建筑的构造上，玻璃、钢铁结构让现代人可以在室内借到大片天光，开放式钢结构替代传统建筑的木构材料，屋面形态的设计突破了中国传统建筑“大屋顶”在采光方面的束缚。由几何形态构成的坡顶，首先，屋顶之上立体几何形体的玻璃天窗设计独特。借鉴了中国传统建筑中老虎天窗的做法并进行改良，天窗开在了屋顶的中间部位，这样屋顶的立体几何形天窗和其下的斜坡屋面形成一个折角，呈现出三维造型效果，不仅解决了传统建筑在采光方面的实用性难题，更丰富和发展了中国建筑的屋面造型样式。'
]


export default class SpotIntroPanel extends Panel {
    public iconImage: eui.Image;
    public closeBtn: eui.Button;
    public introGroup: eui.Group;
    public introTxt: eui.Label;
    public spotNameTxt: eui.Label;

    public get skinKey() { return 'SpotIntroPanel' }
    public get groupName() { return 'spotintro_panel' }

    private spotIndex: number
    constructor(data: any) {
        super(data);
        this.spotIndex = (data && data.spotIndex) ? data.spotIndex : 0;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();

    }

    removeEvents(): void {
        super.removeEvents();

    }

    private onLoad(): void {
        //景点图片
        this.iconImage.source = resources[this.spotIndex];
        //景点名称
        this.spotNameTxt.text = spotNames[this.spotIndex];
        //景点介绍
        this.introTxt.text = intros[this.spotIndex];
    }


}