"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Buried_1 = require("./../../libs/tw/util/Buried");
var sceneTypes_1 = require("./../types/sceneTypes");
var Panel_1 = require("../views/Panel");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var GuidePanel = (function (_super) {
    __extends(GuidePanel, _super);
    function GuidePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(GuidePanel.prototype, "skinKey", {
        get: function () { return 'Guide'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuidePanel.prototype, "groupName", {
        get: function () { return 'guide_panel'; },
        enumerable: true,
        configurable: true
    });
    GuidePanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct(function () {
            this.showMaskAct();
        }.bind(this));
    };
    GuidePanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    GuidePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    GuidePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    GuidePanel.prototype.onLoad = function () {
        this.bgmask.visible = false;
    };
    GuidePanel.prototype.onTap = function () {
        this.hidePanel();
        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
    };
    GuidePanel.prototype.onTouchTap = function () {
        _super.prototype.onTouchTap.call(this);
        this.onTap();
        //引导点击
        var startDpmOut = Buried_1.Buried.connectDpm(110, 1, 1); // 点击埋点   
        var startDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        var exposure = Buried_1.Buried.createExposure(startDpmOut, startDcmOut);
        NetManager_1.NetManager.ins.clickLog(exposure);
    };
    //遮罩动画
    GuidePanel.prototype.showMaskAct = function () {
        this.bgmask.visible = true;
        var shape = new egret.Shape();
        shape.graphics.beginFill(0);
        shape.graphics.drawCircle(0, 0, 810);
        shape.graphics.endFill();
        this.panelGroup.addChild(shape);
        shape.x = 375;
        shape.y = 360; //810;
        // shape.anchorOffsetX = 405;
        // shape.anchorOffsetY = 405;
        this.actGroup.visible = true;
        this.actGroup.mask = shape;
        // shape.width = 1000;
        // shape.height = 1000;
        this.actGroup.mask = shape;
        var endScale = 60 / 810;
        egret.Tween.get(shape).to({ scaleX: endScale, scaleY: endScale }, 300, egret.Ease.cubicOut).call(function () {
        }.bind(this));
    };
    //循环播放动画
    GuidePanel.prototype.playAnimation = function (target, isLoop) {
        if (isLoop) {
            for (var key in target.items) {
                target.items[key].props = { loop: true };
            }
        }
        target.play();
    };
    return GuidePanel;
}(Panel_1.default));
exports.default = GuidePanel;
__reflect(GuidePanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/guidePanel/GuidePanel\".GuidePanel");
//# sourceMappingURL=GuidePanel.js.map