"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("./../../manager/DataManager");
var NetManager_1 = require("../../manager/NetManager");
var ActivityModel_1 = require("../common/ActivityModel");
var GameModel = (function (_super) {
    __extends(GameModel, _super);
    function GameModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 获取规则数据
     */
    GameModel.prototype.getRule = function (callback) {
        if (DataManager_1.DataManager.ins.getRuleData) {
            callback(true);
        }
        else {
            NetManager_1.NetManager.ins.getRule(callback);
        }
    };
    /**
     * 获取活动奖品数据
     */
    GameModel.prototype.getOptions = function (callback) {
        if (DataManager_1.DataManager.ins.getOptionsData) {
            callback(true);
        }
        else {
            NetManager_1.NetManager.ins.getOptions(callback);
        }
    };
    /**
     * 开始游戏
     * @param callback
     * @param isAgain
     * @param credits
     * @param customizedType
     */
    GameModel.prototype.doStart = function (callback, isAgain, credits, customizedType) {
        var _this = this;
        if (isAgain === void 0) { isAgain = false; }
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager_1.NetManager.ins.doStart(function (success) {
            if (success) {
                _this.getStartOrderStatus(callback, customizedType);
            }
            else {
                callback(success);
            }
        }, isAgain, credits, customizedType);
    };
    /**
     * 查询订单结果
     * @param callback
     * @param ticketId
     * @param customizedType
     */
    GameModel.prototype.getStartOrderStatus = function (callback, customizedType) {
        NetManager_1.NetManager.ins.getStartStatus(callback, DataManager_1.DataManager.ins.doStartData.ticketId, function () { return DataManager_1.DataManager.ins.getStartStatusData.code != 1; }, 5, customizedType);
    };
    /**
     * 获取用户数据
     * @param callback
     */
    GameModel.prototype.getInfo = function (callback) {
        NetManager_1.NetManager.ins.getInfo(callback);
    };
    /**
     * 获取夏日活动用户数据
     * @param callback
     */
    GameModel.prototype.getSummerInfo = function (callback, rankBaseConfigId) {
        NetManager_1.NetManager.ins.getSummerInfo(callback, rankBaseConfigId);
    };
    /**
     * 阶段数据提交
     * @param callback
     * @param dynamicStr 数据
     */
    GameModel.prototype.datapashData = function (callback, dynamicStr) {
        NetManager_1.NetManager.ins.datapash(null, DataManager_1.DataManager.ins.doStartData.ticketId, dynamicStr);
    };
    /**
     * 猜扑克
     * @param callback
     * @param plugId 插件ID
     * @param ruleId 集卡规则ID
     * @param betting 0大1小2红3黑
     */
    GameModel.prototype.guessPoker = function (callback, plugId, ruleId, betting) {
        NetManager_1.NetManager.ins.guessPoker(callback, plugId, DataManager_1.DataManager.ins.doStartData.ticketId, ruleId, betting);
    };
    /**
     * 提交游戏成绩
     * @param callback
     * @param score 得分
     * @param allDynamics 防作弊数据
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机
     */
    GameModel.prototype.gameSubmitData = function (callback, score, allDynamics, checkScore, customizedType) {
        var _this = this;
        NetManager_1.NetManager.ins.gameSubmit(function (success) {
            if (success) {
                _this.getSubmitResult(callback, DataManager_1.DataManager.ins.gameSubmitData.orderId);
            }
            else {
                callback(success);
            }
        }, DataManager_1.DataManager.ins.doStartData.ticketId, score, '[]', DataManager_1.DataManager.ins.doStartData.submitToken, JSON.stringify(allDynamics), checkScore, customizedType);
    };
    /**
     * 查询提交结果
     * @param callback
     * @param orderId
     */
    GameModel.prototype.getSubmitResult = function (callback, orderId) {
        NetManager_1.NetManager.ins.getSubmitResult(callback, orderId, function () {
            return DataManager_1.DataManager.ins.gameGetSubmitResultData.flag;
        });
    };
    /**
     * 获取实时排行榜数据
     * @param callback
     * @param type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param count
     */
    GameModel.prototype.realtimerank = function (callback, type, count) {
        if (type === void 0) { type = 0; }
        if (count === void 0) { count = 30; }
        NetManager_1.NetManager.ins.realtimerank(callback, type, count);
    };
    return GameModel;
}(ActivityModel_1.ActivityModel));
exports.GameModel = GameModel;
__reflect(GameModel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/libs/tw/model/common/GameModel\".GameModel");
//# sourceMappingURL=GameModel.js.map