import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
export default class PrizePanel extends Panel {
    private mdata: any;

    public prizeImage: eui.Image;
    public closeBtn: eui.Button;
    public prizeName: eui.Label;
    public useBtn: eui.Group;

    private isplug: boolean;
    private lottery: any;
    public get skinKey() { return 'PrizePanel' }
    // public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);

    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function () {

        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    removeEvents(): void {
        super.removeEvents();
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    private onLoad() {

        let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);

        this.mdata = DataManager.ins.getData(NetName.EXCHANGE_PROJECT).data;
        this.prizeName.text = this.mdata.name;
        this.prizeImage.source = this.mdata.icon;
        // switch (this.lottery.type) {
        //     case LotteryType.VIRTUAL:
        //     case LotteryType.OBJECT:
        //     case LotteryType.ALIPAY:
        //     case LotteryType.PHONEBILL:
        //     case LotteryType.QB:
        //         this.prizeImage.width = 250;
        //         this.prizeImage.height = 250;
        //         break;
        //     case LotteryType.THANKS:
        //         break;
        //     default:
        //         this.prizeImage.width = 520;
        //         this.prizeImage.height = 250;
        //         break;
        // }
    }

    onUse() {
        // window.location.href = this.mdata.url;
    }


    private onTap_ok(e: egret.TouchEvent): void {

        let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
        
        this.onUse();
        this.onTouchTap();
    }

}