import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class GameOverPanel extends Panel {
    public closeBtn: eui.Button;
    public knowBtn: eui.Button;


    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }
    onTap_knowBtn() {
        //关闭弹框
        this.hidePanel();
    }

    private onLoad(): void {

    }


}