
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";

export default class MsgPanel extends Panel {
    public okBtn:eui.Button;
    public titleLb0:eui.Label;
    public titleLb1:eui.Label;
    private mData:any;


    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        this.okBtn['nameLb'].stroke = 5;
        this.okBtn['nameLb'].strokeColor = 0xf05a35;

        if(this.mData){
            switch(this.mData.type){
                case 0:
                    this.titleLb0.text = '未登录';
                    this.titleLb1.text = '您还没有登录哦！';

                    // if(this.mData.text){
                        this.okBtn['nameLb'].text = '去登录';
                    // }
                break;
                case 1:
                    // this.titleLb0.text = DataManager.ins.customCfgData.unitName + '不足';
                    // this.titleLb1.text = '抱歉！您当前' + DataManager.ins.customCfgData.unitName + '不足';

                    // if(this.mData.text){

                        // this.okBtn['nameLb'].text = '赚' + DataManager.ins.customCfgData.unitName; 
                    // }
                break;
            }

        }

        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);
        if(this.mData){
            if(this.mData.type == 0){
                // if(DataManager.ins.customCfgData.isNotLoginUser){
                //     window['requirelogin']();
                // }
                // window.location.href = DataManager.ins.customCfgData.login;
            }else if(this.mData.type == 1){
                if(this.mData.isGoHome){
                }
                // let url = DataManager.ins.customCfgData.getCreditsLink;
                // if(url != null && url != ''){

                //     window.location.href = url;
                // }
            }
        }
        this.hidePanel();
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        this.onTap();
    }


    private getAjax():void{
        
    }

}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function 
}