"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("./../../libs/tw/manager/DataManager");
var sceneTypes_1 = require("./../types/sceneTypes");
var Scene_1 = require("../views/Scene");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Loading_1 = require("../loading/Loading");
var StartScene = (function (_super) {
    __extends(StartScene, _super);
    function StartScene(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(StartScene.prototype, "skinKey", {
        get: function () { return 'StartScene'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(StartScene.prototype, "groupName", {
        get: function () { return 'start_scene'; },
        enumerable: true,
        configurable: true
    });
    StartScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.showRankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        this.guideGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_guideGroup, this);
    };
    StartScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.rankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.showRankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        this.guideGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_guideGroup, this);
    };
    StartScene.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
        this.percentHeight = 100;
    };
    StartScene.prototype.preLoadRes = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        //加载背景并设置背景图片
                        _a = this;
                        return [4 /*yield*/, RES.getResAsync('startBg01_jpg')];
                    case 1:
                        //加载背景并设置背景图片
                        _a.bgtexture = _b.sent();
                        console.log('载背景并设置背景图片mainscene');
                        return [4 /*yield*/, RES.getResAsync('bgIcon0_png')];
                    case 2:
                        _b.sent();
                        return [4 /*yield*/, RES.getResAsync('bgIcon1_png')];
                    case 3:
                        _b.sent();
                        return [2 /*return*/, new Promise(function (resolve, reject) {
                                resolve();
                            })];
                }
            });
        });
    };
    StartScene.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.mainbg.texture = this.bgtexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    };
    StartScene.prototype.onLoad = function () {
        NetManager_1.NetManager.ins.achieveInfo(function (success, data) {
            console.log(data);
            if (success && data) {
                this.prizeData = data.data;
                this.initAward(data.data);
            }
            else {
                console.log('首页奖品信息未获取到');
            }
        }.bind(this));
        this.initUI();
        // this.addEventListener(egret.Event.ENTER_FRAME, this.onframe, this);
    };
    StartScene.prototype.initUI = function () {
        this.hasPrize = 0;
        this.flowerArr = [];
        this.plugIdArr = window['plugIdArr'] ? window['plugIdArr'] : [2201, 1302, 2221, 3331];
        this.flowerCountArr = [60, 90, 120, 200];
        this.flowerNameArr = ['橘色', '粉红色', '紫色', ''];
        this.playAnimation(this['roleAct']);
        this.playAnimation(this['cloudAct']);
        this.playAnimation(this['roleGameAct0']);
        this.playAnimation(this['roleGameAct1']);
        this.guideMaskRect.visible = false;
        this.guideGroup.visible = false;
        this.gameRoleMc.y = this.parent.height;
        this.startBtn['startBtnLb'].text = '消耗积分:' + DataManager_1.DataManager.ins.getInfoData.status.text;
        this.createFlower();
        NetManager_1.NetManager.ins.getCredits(function () {
            this.integralLb.text = '当前积分:' + DataManager_1.DataManager.ins.getCreditsData.consumerCredits;
        }.bind(this));
        // this.playGameRoleAct();
        if (DataManager_1.DataManager.ins.getInfoData.status.code == 5) {
            this.showRankBtn.visible = true;
            this.startBtn.visible = false;
        }
        else {
            this.showRankBtn.visible = false;
            this.startBtn.visible = true;
        }
        for (var i = 0; i < 3; i++) {
            this['starImg' + i].alhpa = 0.6;
            this['starImg' + i].scaleX = 0.6;
            this['starImg' + i].scaleY = 0.6;
            egret.Tween.get(this['starImg' + i], { loop: true }).wait(200 * i).to({ alpha: 1 }, 100).wait(800).to({ alpha: 0.6 }, 100);
            egret.Tween.get(this['starImg' + i], { loop: true }).wait(200 * i).to({ scaleX: 1, scaleY: 1 }, 500).to({ scaleX: 0.6, scaleY: 0.6 }, 500);
        }
    };
    StartScene.prototype.showStartAct = function () {
        //开始游戏ui动画处理
        egret.Tween.get(this.titleImg).to({ y: -302, alpha: 0 }, 500, egret.Ease.cubicOut);
        egret.Tween.get(this.uiGroup).to({ alpha: 0 }, 500, egret.Ease.cubicOut);
        this.uiGroup.touchChildren = false;
        //开始人物位移动画
        egret.Tween.get(this.roleGroup).to({
            x: this.roleGroup.x - 900,
            y: this.roleGroup.y - 322
        }, 270, egret.Ease.cubicOut).to({
            x: this.roleGroup.x + 237,
            y: this.roleGroup.y + 12,
        }, 520, egret.Ease.cubicOut);
        egret.Tween.get(this.roleGroup).wait(270).to({ scaleX: -1.34,
            scaleY: 1.34 }, 140);
        //背景图片
        egret.Tween.get(this.bgGroup).wait(270).to({
            y: 1624 - 3905
        }, 830, egret.Ease.cubicOut);
    };
    StartScene.prototype.initAward = function (dataArr) {
        for (var i = 0; i < dataArr.length; i++) {
            var pData = dataArr[i];
            var idx = pData.level - 1;
            var rect = new eui.Rect(90, 90, 0x95fcf3);
            this['barGroup' + idx].addChild(rect);
            rect.y = 90 * (1 - Math.min(pData.achieveNum / this.flowerCountArr[idx], 1));
            var mask = new egret.Shape();
            mask.x = 45;
            mask.y = 45;
            mask.graphics.beginFill(0);
            mask.graphics.drawCircle(0, 0, 45);
            mask.graphics.endFill();
            this['barGroup' + idx].addChild(mask);
            this['flawerNumLb' + idx].text = this.flowerCountArr[idx] + '朵' + this.flowerNameArr[idx] + '桃花';
            rect.mask = mask;
            if (pData.canOpen && !pData.opened) {
                this.hasPrize++;
                this['canGetTips' + idx].visible = true;
                this['prizeIconImg' + idx].source = 'sPrizeIcon0_png';
                this['clickGroup' + idx].name = idx;
                // this['barGroup' + idx].touchEnabled = true;
                this['clickGroup' + idx].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_barGroup, this);
                var ox = this['prizeIconImg' + idx].x;
                var oy = this['prizeIconImg' + idx].y;
                egret.Tween.get(this['prizeIconImg' + idx], { loop: true }).to({ x: ox - 3 }, 50).to({ x: ox }, 50).wait(500).to({ x: ox + 3 }, 50).to({ x: ox }, 50);
            }
            else {
                this['canGetTips' + idx].visible = false;
                this['prizeIconImg' + idx].source = 'sPrizeIcon1_png';
            }
            if (pData.opened) {
                this['prizeIconImg' + idx].visible = false;
                this['barGroup' + idx].visible = false;
                this['prizeDisableImg' + idx].visible = true;
            }
            else {
                this['prizeIconImg' + idx].visible = true;
                this['barGroup' + idx].visible = true;
                this['prizeDisableImg' + idx].visible = false;
            }
        }
    };
    //点击领奖抽插件
    StartScene.prototype.onTap_barGroup = function (e) {
        console.log('e.target.name=' + e.target.name);
        var idx = e.target.name;
        this.getPlugPrize(idx);
    };
    //创建花元素
    StartScene.prototype.createFlower = function () {
        var colCount = 2;
        var contW = Math.floor(750 / colCount);
        var contH = 300;
        var rowCount = Math.floor((3905 - 1624 - 300) / contH);
        console.log('rowCount=' + rowCount);
        for (var j = 0; j < rowCount; j++) {
            for (var i = 0; i < colCount; i++) {
                var idx = Math.floor(Math.random() * 4);
                var img = new eui.Image();
                img.source = 'flowerIcon' + idx + '_png';
                this.bgGroup.addChild(img);
                this.flowerArr.push(img);
                var iW = 0;
                var iH = 0;
                if (idx == 2) {
                    img.anchorOffsetX = 50;
                    img.anchorOffsetY = 50;
                    iW = 70;
                    iH = 70;
                }
                else if (idx == 3) {
                    iW = 72;
                    iH = 70;
                }
                else {
                    iW = 65;
                    iH = 69;
                }
                img.alpha = 0;
                img.x = i * contW + (contW - iW) * Math.random();
                img.y = 1624 + j * contH + (contH - iH) * Math.random();
            }
        }
    };
    //播放花朵显示动效
    StartScene.prototype.showFlower = function () {
        var time = 50;
        egret.Tween.get(this.bgGroup, { loop: true }).wait(time).call(function () {
            if (this.flowerArr.length) {
                var target = this.flowerArr.shift();
                egret.Tween.get(target).to({ alpha: 1 }, time, egret.Ease.cubicOut);
            }
            else {
                egret.Tween.removeTweens(this.bgGroup);
                this.playGameRoleAct();
            }
        }, this);
    };
    //角色出现，过场动画
    StartScene.prototype.playGameRoleAct = function () {
        var pH = this.parent.height;
        this.gameRoleMc.y = pH;
        egret.Tween.get(this.gameRoleMc).to({ y: pH - 500 }, 200).to({ y: pH - 400 }, 200).call(function () {
            this.showGuide();
        }, this);
    };
    StartScene.prototype.showGuide = function () {
        var isfirst = true; //egret.localStorage.getItem('showGuide');
        if (!isfirst) {
            // egret.localStorage.setItem('showGuide', 'true');
            this.guideMaskRect.visible = true;
            this.guideMaskRect.alpha = 0;
            this.guideGroup.visible = true;
            this.guideGroup.alpha = 0;
            var time = 200;
            egret.Tween.get(this.guideMaskRect).to({ alpha: 1 }, time, egret.Ease.cubicOut);
            egret.Tween.get(this.guideGroup).to({ alpha: 1 }, time, egret.Ease.cubicOut).call(function () {
                this.playAnimation(this['handAct']);
            }, this);
        }
        else {
            sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.GAME_SCENE, {
                prizeData: this.prizeData,
                hasPrize: this.hasPrize,
                flowerCountArr: this.flowerCountArr
            });
        }
    };
    StartScene.prototype.onTap_ruleBtn = function () {
        console.log('点击rule');
        panelCtrl_1.default.instance.btnDelay(this.ruleBtn);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RULE_PANEL);
    };
    StartScene.prototype.onTap_rankBtn = function () {
        console.log('点击rank');
        panelCtrl_1.default.instance.btnDelay(this.showRankBtn);
        panelCtrl_1.default.instance.btnDelay(this.rankBtn);
        NetManager_1.NetManager.ins.realtimerank(function (success) {
            if (success) {
                console.log(DataManager_1.DataManager.ins.realTimeRankData);
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RANK_PANEL);
            }
            else {
                console.log('获取排行榜数据失败');
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: '获取排行榜数据失败', line: 1 });
            }
        }.bind(this), 0, 20);
    };
    StartScene.prototype.onTap_startBtn = function () {
        console.log('点击startBtn');
        panelCtrl_1.default.instance.btnDelay(this.startBtn);
        if (DataManager_1.DataManager.ins.getInfoData.status.code == 3) {
            // 参与次数已用完
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: '今日次数已用完', line: 1 });
            return;
        }
        else if (DataManager_1.DataManager.ins.getInfoData.status.code == 2) {
            // 积分不足
            panelCtrl_1.default.instance.showMsg('okBtn', 1);
            return;
        }
        else if (DataManager_1.DataManager.ins.getInfoData.status.code == 1) {
            // 未登录
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: '您未登录', line: 1 });
            return;
        }
        else {
            panelCtrl_1.default.instance.showMsg('okBtn', 0, function () {
                this.dostart();
            }.bind(this));
        }
    };
    StartScene.prototype.dostart = function () {
        Loading_1.default.instace.show();
        NetManager_1.NetManager.ins.doStart(function (success) {
            var _this = this;
            if (success) {
                NetManager_1.NetManager.ins.getStartStatus(function (data) {
                    console.log('data轮询失败=' + data);
                    if (data == 'pollingFaild' || !data) {
                        panelCtrl_1.default.instance.showMsg('okBtn', 2);
                        //PanelCtrl.instance.showMsg('okBtn', 4, null, null, '如积分丢失,联系客服核实！');
                    }
                    else {
                        //开始游戏
                        // PanelCtrl.instance.removeImmediately();
                        Loading_1.default.instace.hide();
                        _this.showStartAct();
                        _this['roleAct'].pause();
                        _this.showFlower();
                    }
                }, DataManager_1.DataManager.ins.doStartData.ticketId, function () { return DataManager_1.DataManager.ins.getStartStatusData.code == 0; }, 5);
            }
            else {
                // Loading.instace.hide();
                console.log('dostart失败');
                panelCtrl_1.default.instance.showMsg('okBtn', 2);
                //统一处理异常？？？？？？？
                // PanelCtrl.instance.showMsg('okBtn', 4, null, null, '请刷新重试！');
            }
        }.bind(this), false);
    };
    /**
     * 抽首页插件
     * @param idx 插件顺序
     */
    StartScene.prototype.getPlugPrize = function (idx) {
        var _this = this;
        var activityId = this.plugIdArr[idx];
        Loading_1.default.instace.show();
        NetManager_1.NetManager.ins.doJoinPlugDraw(function (isSuccess) {
            if (isSuccess) {
                NetManager_1.NetManager.ins.getPlugOrderStatus(function (data) {
                    if (data == 'pollingFaild' || !data) {
                        console.log('轮询失败：' + data);
                        Loading_1.default.instace.hide();
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.WARNING_PANEL);
                    }
                    else {
                        Loading_1.default.instace.hide();
                        _this['canGetTips' + idx].visible = false;
                        _this['prizeIconImg' + idx].visible = false;
                        _this['barGroup' + idx].visible = false;
                        _this['prizeDisableImg' + idx].visible = true;
                        egret.Tween.removeTweens(_this['prizeIconImg' + idx]);
                        _this['clickGroup' + idx].removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTap_barGroup, _this);
                        _this.hasPrize--;
                        NetManager_1.NetManager.ins.doJoinRecord(function (success) {
                            if (success) {
                                this.prizeData[idx].opened = true;
                            }
                            else {
                                console.log('传输抽奖记录失败！');
                            }
                        }.bind(_this), idx + 1);
                        //弹出奖品框待处理
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.PRIZE_PANEL, { callback: function () { }.bind(_this), lottery: DataManager_1.DataManager.ins.getPlugOrderStatusData.lottery });
                    }
                }, DataManager_1.DataManager.ins.doJoinPlugDrawData.orderId, function () {
                    return (DataManager_1.DataManager.ins.getPlugOrderStatusData.result == 0);
                }, 10);
            }
            else {
                // 下订单失败
                console.log('抽插件下单失败：' + activityId);
                Loading_1.default.instace.hide();
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.WARNING_PANEL);
            }
        }, activityId);
    };
    StartScene.prototype.onTap_prizeBtn = function () {
        console.log('点击prizeBtn');
        panelCtrl_1.default.instance.btnDelay(this.prizeBtn);
        window.location.href = window["recordUrl"];
    };
    StartScene.prototype.onTap_guideGroup = function () {
        panelCtrl_1.default.instance.btnDelay(this.guideGroup);
        this.guideMaskRect.visible = false;
        this.guideGroup.visible = false;
        this['handAct'].pause();
        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.GAME_SCENE);
    };
    // private shap:egret.Shape;
    // private lineW:number = 0;
    // private num:number = 1;
    // private onframe():void{
    //     // console.log(this.num * this.num / (2 * 0.5));
    //     if(this.lineW > 2500){
    //         return;
    //     }
    //     this.shap.graphics.clear();
    //     this.shap.graphics.beginFill(0);
    //     this.shap.graphics.lineStyle(this.lineW,0,0.8);
    //     this.shap.graphics.beginFill(0x000000,0);
    //     this.shap.graphics.drawCircle(500,500,1300);
    //     this.shap.graphics.endFill();
    //     this.shap.touchEnabled = true;
    //     this.lineW += this.num * this.num / (2 * 0.2);
    //     this.num += 1;
    // }
    //循环播放动画
    StartScene.prototype.playAnimation = function (target, isLoop) {
        if (isLoop === void 0) { isLoop = true; }
        if (isLoop) {
            for (var key in target.items) {
                target.items[key].props = { loop: true };
            }
        }
        target.play();
    };
    return StartScene;
}(Scene_1.default));
exports.default = StartScene;
__reflect(StartScene.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/startScene/StartScene\".StartScene");
//# sourceMappingURL=StartScene.js.map