import MovieClip from "../../physics/movieclip/MovieClip";
import LabelType from "../LabelType";

const createBoom = (scale) => {
    const boomTexture = RES.getRes('boom_json');
    //炸弹纹理种炸弹的尺寸默认58，不进行缩放
    //气泡和炸弹的比例为100/58
    const animation = createBoomMovieClip(boomTexture, 98 / 98 * scale);
    return animation
}

const createBoomMovieClip = (spritesheet, scale = 1) => {
    const list = ['礼盒0000', '礼盒0001', '礼盒0002', '礼盒0003', '礼盒0004', '礼盒0005', '礼盒0006',
        '礼盒0007', '礼盒0008', '礼盒0009', '礼盒0010', '礼盒0011', '礼盒0012', '礼盒0013', '礼盒0014', '礼盒0015'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 4,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [255 / 500, 209 / 500]
    });
    movieclip.lable = LabelType.Boom
    return movieclip
}

export default createBoom