import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";

export class ExChangeItem extends eui.Component{
    private callBack:Function;

    public itemImg:eui.Image;
    public itemValue:eui.Label;
    public itemNameLb:eui.Label;
    public exchangeBtn:eui.Button;

    public pData:any;
    public orderArr:any[];

    /**
     * 库存是否充足
     */
    public sufficient:boolean;

    constructor(callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/ui/ExChangeItemSkin.exml';

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.exchangeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_exchangeBtn, this)
        if (this.skin) {
            this.onSkinComplete();
        }
        
        this.callBack = callBack;
    }

    private onSkinComplete():void{

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

    }

    private onTap_exchangeBtn():void{
        if(this.callBack){
            this.callBack(this.pData, this);
        }

        if(this.pData.blackBoxFlag){
            let startDpmOut = Buried.connectDpm(110, 4, 4); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.clickLog(exposure);
        }else{
            console.log('this.pData.prizeId',this.pData.prizeId);
            if(this.pData.prizeId == 'sss_1'){
                let startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);
            }else if(this.pData.prizeId == 'sss_2'){
                let startDpmOut = Buried.connectDpm(110, 4, 2); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);

            }else if(this.pData.prizeId == 'sss_3'){
                let startDpmOut = Buried.connectDpm(110, 4, 3); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
                NetManager.ins.clickLog(exposure);

            }
        }
    }

}