import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import { playSound } from '../ctrls/soundCtrl';
export default class StartScene1 extends Scene {
    public ruleBtn:eui.Button;
    public soundBtn:eui.Group;
    public headImg:eui.Image;
    public qiqiuImg:eui.Image;

    public actGroup:eui.Group;

    private startBtn:SVGA.EgretMovieClip;
    private birdfly:SVGA.EgretMovieClip;
    private parser:SVGA.Parser;

    // 用于控制全局音乐是否播放和音乐按钮状态
    public static isPlayMusic: boolean = true;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);

    }
    showAct():void{
        // this.alpha = 0;
        // egret.Tween.get(this).to({alpha:1}, 800);
    }

    initEvents() {
        super.initEvents();
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.soundBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.soundBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);

        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_start, this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        this.birdfly = await PanelCtrl.instance.getSvga('resource/assets/svga/start/birdfly.svga') as SVGA.EgretMovieClip;
        this.startBtn = await PanelCtrl.instance.getSvga('resource/assets/svga/start/startBtn.svga') as SVGA.EgretMovieClip;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        
        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        let startDpmOut; 
        let startDcmOut;
        let exposure;
        startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);
        NetManager.ins.showLog(exposure);

        this.initUI();
    }

    private initUI(): void {

        var u = navigator.userAgent;
        var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        // var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g

        if(!this.getIsWxClient() && iphone){
            // window['isOpenMusic'] = false;
            this['mImg0'].visible = false;
            this['mImg1'].visible = true;
        }else{
            window['isOpenMusic'] = true;
            this['mImg0'].visible = true;
            this['mImg1'].visible = false;

        }
        this.initData();
        this.initSvga();

    }

    private initData(isPlay:boolean = false):void{
        this.actGroup.visible = true;
    }

    private initSvga():void{

        setTimeout(() => {
            this.actGroup.addChild(this.birdfly);
            this.birdfly.play();
            let qy = this.qiqiuImg.y;
            egret.Tween.get(this.qiqiuImg, {loop:true}).to({y:qy - 30}, 2000).to({y:qy}, 2000);

            this.startBtn.play();
            this.startBtn.x = 205;
            this.startBtn.y = 950;
            this.addChild(this.startBtn);
        }, 330);
        this.startBtn.touchEnabled = true;
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_start, this);

    }

    private onTap_start():void{
        PanelCtrl.instance.btnDelay(this.startBtn);
        var u = navigator.userAgent;
        var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端

        if(!this.getIsWxClient() && iphone){
            if((window['isOpenMusic'] == undefined || window['isOpenMusic'] == null)){
                window['isOpenMusic'] = true;
                window['musicPlay'](true);

                this['mImg0'].visible = true;
                this['mImg1'].visible = false;
            }
        }

        playSound('startBtnSound');
        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.startBtn.startAniRange(this.startBtn.totalFrames, this.startBtn.totalFrames, 1);
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);


        //处理音频自动播放，每个audio标签都要获取一次交互操作，接下来才能自动播放
        // var music:any = document.getElementById('music');
        // music.src = 'https://yun.duiba.com.cn/db_games/activity/music/w20191006/sound2.mp3';
        // if(music){
        //     music.play();
        //     // music.pause();
        // }

        // setTimeout(() => {
        //     this.roleHead.startAniRange(1, this.roleHead.totalFrames, 1);
        //     this.headImg.visible = false;
        // }, 500);
        // setTimeout(() => {
        //     this.mainGroup.verticalCenter = NaN;
        // }, 2500);

    }


    private onTap_ruleBtn(): void {

        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    private onTap_soundBtn(){
        if(window['isOpenMusic'] == undefined || window['isOpenMusic'] == null || window['isOpenMusic'] == false){
            window['musicPlay'](true);
            window['isOpenMusic'] = true;
            this['mImg0'].visible = true;
            this['mImg1'].visible = false;
        }else{
            window['musicPlay'](false);
            window['isOpenMusic'] = false;
            this['mImg0'].visible = false;
            this['mImg1'].visible = true;
        }

    }

    private getIsWxClient ():boolean {
        var ua:string = window['navigator'].userAgent.toLowerCase();
        console.log(ua);
        if (ua.indexOf("micromessenger") != -1) {
            return true;
        }
        return false;
    };

}
