import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { ImageAni } from './ImageAni';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { Buried } from '../../libs/tw/util/Buried';
export default class SignSucPanel extends Panel {
    public closeBtn: eui.Button;
    public signDaysTxt: eui.Label;
    public redMapleTxt: eui.Label;
    public tomSignTxt: eui.Label;
    public shareBtn: eui.Button;

    private sData;
    // public shareTxt: eui.Label;



    public get skinKey() { return 'SignSucPanel' }
    public get groupName() { return 'signsuc_panel' }

    constructor(data: any) {
        super(data);
        this.sData = data.sData;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    onTap_shareBtn() {
        PanelCtrl.instance.btnDelay(this.shareBtn);
        let startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        console.log(666666);
        NetManager.ins.clickLog(exposure);
        //进入分享流程
        var param = {
			"shareTitle" : window['shareTitle'] ? window['shareTitle'] : '美好生活上上签',// 标题
			"shareTextUrl" : window['shareTextUrl'] ? window['shareTextUrl'] : 'https://activity.m.duiba.com.cn/customShare/share?id=3473',// 链接
			"shareText" : window['shareText'] ? window['shareText'] : '每日一签，秋日好礼等你拿',// 分享文本内容
			"sequence":'010',//分享三个按钮的显示与隐藏
			"showDialog":'true', //是否需要底部弹出层
			"shareAlertTitle":'分享', //分享弹出层标题
			"callback":"shareCallBack" //分享回调方法
        };
        
        window['shareCallBack'] = (data)=>{
            if(data == "0"){
				//alert("分享成功");
                console.log("分享成功");
                NetManager.ins.shareData((success)=>{
                    if(success){
                        GDispatcher.dispatchEvent('refreshMoney');
                        let data = DataManager.ins.getData(NetName.SHARE).data;
                        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享成功 +' + data.prizeAmount + '红枫'});
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.EXMSG_PANEL);
                    }
                });
			}else{
				//alert("分享失败");
                console.log("分享失败");
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享失败！'});
			}
        }
        console.log('ThirdApp',window['ThirdApp']);
        window['ThirdApp'].webviewShare(param);
    }


    private onLoad(): void {
        let startDpmOut = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);


        if(this.sData){
            //根据数据
            let day = this.sData.serialDays;
            if(this.sData.serialDays > 99){
                day = '99+';
            }
            this.signDaysTxt.text = "已连续签到" + day + "天";
            this.redMapleTxt.text = "红枫+" + this.sData.prizeAmount;
            this.tomSignTxt.text = "明天签到 红枫+" + this.sData.tomorrowPrizeAmount;
            this.shareBtn.label = '分享获得' + this.sData.sharePrizeAmount + '红枫';

        }

        //动画
        var arr=[]
        for (var i = 1; i <= 11; i++) {
            arr.push("rayAni" + i + "_png");
        } 
        var rayAni=new ImageAni(arr);
        this.addChild(rayAni)
        rayAni.x=125;
        rayAni.y=340;
        rayAni.play();
    }


}