import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetName } from "../../libs/tw/enum/NetName";
export default class ShowImgPanel extends Panel {
    public closeBtn: eui.Button;
    public knowBtn: eui.Button;
    public showImg:eui.Image;

    public img:any;
    public bgImg:eui.Image;
    public panelGroup:eui.Group;
    public personRankLb0:eui.Label;
    public personRankLb1:eui.Label;


    public get skinKey() { return 'ShowImgPanel' }
    public get groupName() { return 'showimg_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        // this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        // this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }

    onTouchTap():void{
        super.onTouchTap();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);

        this.img.style.display = 'none';
    }
    // onTap_knowBtn() {

    //     PanelCtrl.instance.show(ModuleTypes.BAG_PANEL);
    //     //关闭弹框
    //     this.hidePanel();
    // }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        
        this.bgtexture = await RES.getResAsync('showPanelbg_jpg');
        console.log('载背景并设置背景图片mainscene');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    private async onLoad() {

        this.bgImg.texture = this.bgtexture;
        let data = DataManager.ins.getData(NetName.GET_COOP_TIEMS);
        if(data && data.data){
            this.personRankLb0.text = '你是第 ' + data.data.completeNum + ' 位';
            this.personRankLb1.text = '你是第 ' + data.data.completeNum + ' 位';
        }

        let idx;
        if(window['conmpleteImgArr'].length > 0){
            let len = window['conmpleteImgArr'].length;
            idx = Math.floor(len * Math.random());
            idx = window['conmpleteImgArr'][idx];
        }else{
            idx = Math.floor(5 * Math.random());
        }
        let imgname = 'shareImg' + idx + '_png';

        await RES.getResAsync(imgname);

        this.showImg.source = imgname;

        setTimeout(() => {
            this.scanImg();
        }, 300);
        
    }

    private scanImg():void{
        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        // let height = this.stage.stageHeight > 1206 ? 1206 : this.stage.stageHeight;
        renderTexture.drawToTexture(this.panelGroup, new egret.Rectangle(0, 0, 750, 1155));
        let imageData = renderTexture.toDataURL("image/png");

        this.img = document.getElementById('shareImg');
        this.img.style.position = 'absolute';
        let widthP = 100;//Math.floor(600 * 100 / 750 );
        this.img.style.width = "100%";//`${widthP}%`;
        let leftP = 0;//Math.floor(75 * 100 / 750);
        this.img.style.left = "0%";//`${leftP}%`;
        let topP = Math.floor(50 * 100 / 750);
        this.img.style.top = "0%";//`${topP}%`;
        this.img['src'] = imageData;

        this.img.style.display = 'block';

        let returnBtn = document.getElementById('returnBtn');
        returnBtn.style.display = 'block';
        returnBtn.onclick = ()=>{
            this.onTouchTap();
            returnBtn.style.display = 'none'
        }

        // let skipBagBtn = document.getElementById('skipBagBtn');
        // skipBagBtn.style.display = 'block';
        // skipBagBtn.onclick = ()=>{
        //     // this.onTouchTap();
        //     // skipBagBtn.style.display = 'none';
        //     window.location.href = window['skipUrl'] ? window['skipUrl'] : 'https://m.21jingji.com/dynamic/activity/xjhb';

        // }

        
    }


}