import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
export default class PrizePanel extends Panel {
    private mdata: any;
    private pdata: any;

    public textContentLb:eui.Label;
    public prizeNameLb:eui.Label;
    public prizeImage: eui.Image;
    public allTipLb:eui.Label;
    public qiqiuImg:eui.Image;
    public closeBtn: eui.Button;
    public jietuBtn: eui.Button;
    public buildImg:eui.Image;
    public lightImg:eui.Image;
    public jietuBigBtn:eui.Button;
    public contentGroup:eui.Group;
    public prizeActGroup0:eui.Group;
    public prizeActGroup1:eui.Group;
    private prizeAct0:SVGA.EgretMovieClip;
    private prizeAct1:SVGA.EgretMovieClip;
    public continueBtn:eui.Button;//-17 85

    public codeGroup:eui.Group;

    private textContentArr:any[];

    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.pdata = data;

    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function () {

        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.continueBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_continue, this);
        this.jietuBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_jietu, this);
        this.jietuBigBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_big, this);
        // this.prizeImage.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    removeEvents(): void {
        super.removeEvents();
        this.jietuBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_jietu, this);
        this.jietuBigBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_big, this);
        this.continueBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_continue, this);
        // this.prizeImage.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

        egret.Tween.removeTweens(this.lightImg);
        egret.Tween.removeTweens(this.qiqiuImg);

    }

    private onTap_big():void{
        PanelCtrl.instance.btnDelay(this.jietuBigBtn);
        let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.onTap_ok(null);
    }

    private onTap_jietu():void{
        PanelCtrl.instance.btnDelay(this.jietuBtn);
        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.onTap_ok(null);
    }

    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        this.prizeAct0 = await PanelCtrl.instance.getSvga('resource/assets/svga/prize/prizeAct0.svga') as SVGA.EgretMovieClip;
        this.prizeAct1 = await PanelCtrl.instance.getSvga('resource/assets/svga/prize/prizeAct1.svga') as SVGA.EgretMovieClip;
        this.prizeAct0.touchEnabled = false;
        this.prizeAct1.touchEnabled = false;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    private onLoad() {


        let startDpmOut; 
        let startDcmOut;
        let exposure;


        this.prizeActGroup1.touchChildren = false;
        this.prizeActGroup1.touchEnabled = false;

        if(window['conmpleteImgArr'].length == 5){
            this.allTipLb.visible = true;
            this.jietuBigBtn.visible = true;
            this.jietuBtn.visible = false;
            this.continueBtn.visible = false;
            this.contentGroup.y = 402;

            startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
            NetManager.ins.showLog(exposure);
        }else{
            this.allTipLb.visible = false;
            this.jietuBigBtn.visible = false;
            this.jietuBtn.visible = true;
            this.continueBtn.visible = true;
            this.contentGroup.y = 369;

            startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
            NetManager.ins.showLog(exposure);


            startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
            NetManager.ins.showLog(exposure);
        }

        this.buildImg.y = 85;
        egret.Tween.get(this.buildImg).wait(300).to({y:-17}, 500, egret.Ease.cubicOut).call(()=>{
            egret.Tween.get(this.lightImg, {loop:true}).to({rotation:360}, 9000);
        });
        setTimeout(() => {
            this.prizeActGroup0.addChild(this.prizeAct0);
            this.prizeAct0.startAniRange(1, this.prizeAct0.totalFrames, 1);
        }, 300);

        setTimeout(() => {
            this.prizeActGroup1.addChild(this.prizeAct1);
            this.prizeAct1.startAniRange(1, this.prizeAct0.totalFrames, 1);
        }, 630);
        let qy = this.qiqiuImg.y;
        egret.Tween.get(this.qiqiuImg, {loop:true}).to({y:qy - 30}, 2000).to({y:qy}, 2000);

        this.textContentArr = [
            {title:'大桥连接未来',content:'受地理位置影响，澳门的发展史离不开桥梁，港珠澳大桥、澳凼大桥、友谊大桥、西湾大桥、莲花大桥等，承载着澳门丰富的历史感与现代感。'},
            {title:'旅游业超级发达',content:'总人口不到70万的澳门，2018年入境游客人数近3600万人次，今年或突破4000万人次，较1999年增长约5倍。大三巴牌坊、威尼斯人度假村等景点吸引了全世界的游客。'},
            {title:'中西文化交融',content:'作为中西合璧的文化瑰宝，澳门既有妈祖庙等传统建筑，又具有特别的葡式建筑；广式早茶在这里随处可见，葡式蛋挞、猪扒包等西式美食也有其一席之地。'},
            {title:'澳门回归20周年', content:'  “你可知Macau不是我真姓？ 我离开你太久了,母亲！”1999年12月20日，中国政府恢复对澳门行使主权，澳门回到母亲的怀抱。2019年是澳门回归祖国20周年。'},
            {title:'经济增长强劲',content:'作为国际自由港和世界旅游休闲中心，澳门也是世界四大赌城之一。回归以来，GDP翻了8倍增至2018年的4403亿澳门元，人均GDP增至67万澳门元，是全球最富裕的地区之一。'}
        ];
        if(this.pdata){
            let idx = this.pdata.idx;
            this.prizeImage.source = 'icon' + idx + '_png';
            this.prizeNameLb.text = this.textContentArr[idx].title;
            this.textContentLb.text = this.textContentArr[idx].content;
        }
    }

    //返回首页
    private ontap_continue():void{
        PanelCtrl.instance.btnDelay(this.continueBtn);

        let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.onTouchTap();
    }

    onUse() {

    }

    onTouchTap(){
        super.onTouchTap();
        if(window['conmpleteImgArr'].length == 5){
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        }else{
            if(this.pdata && this.pdata.callback){
                this.pdata.callback();
            }
        }
    }

    //截图
    private onTap_ok(e: egret.TouchEvent): void {
        this.hidePanel();
        PanelCtrl.instance.show(ModuleTypes.SHOW_IMG_PANEL);
    }

}