import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
export default class OutOfPrizePanel extends Panel {
    public closeBtn:eui.Button;
    public knowBtn:eui.Group;
    

    public get skinKey() { return 'OutOfPrizePanel' }
    // public get groupName() { return '' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
    }
    onTap_knowBtn() {
        let startDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        //关闭弹框
        this.hidePanel();
    }

    private onLoad(): void {

        let startDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);
    }


}