import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import SceneCtrl from '../ctrls/sceneCtrl';
export default class GameOverPanel extends Panel {
    public closeBtn: eui.Button;
    public againBtn: eui.Button;
    public jietuBtn: eui.Button;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this)
        this.jietuBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_jietuBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this)
        this.jietuBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_jietuBtn, this)
    }
    onTap_againBtn() {
        
        PanelCtrl.instance.btnDelay(this.againBtn);
        let startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
        this.hidePanel();

        NetManager.ins.getCoopTimes((success)=>{
            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        });
    }

    private onTap_jietuBtn():void{
        PanelCtrl.instance.btnDelay(this.jietuBtn);
        let startDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        //关闭弹框
        this.hidePanel();
        PanelCtrl.instance.show(ModuleTypes.SHOW_IMG_PANEL);
    }
    
    onTouchTap():void{
        super.onTouchTap();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);

    }

    private onLoad(): void {

        let startDpmOut; 
        let startDcmOut;
        let exposure;

        startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
            NetManager.ins.showLog(exposure);


            startDpmOut = Buried.connectDpm(110, 5, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
            NetManager.ins.showLog(exposure);

    }


}