let soundOn = true;
let bgChannel: egret.SoundChannel;
let loading = false;
export const getSoundOn = () => {
    return soundOn
}

export const toggleSound = () => {
    soundOn = !soundOn;
    if (bgChannel) {
        if (!soundOn) {
            bgChannel.stop();
            bgChannel = null;
        }
    } else {
        if (soundOn) {
            playBg();
        }
    }
}

export const playBg = async () => {
    if (bgChannel) return;
    if (loading) return;
    loading = true;
    const bg = await RES.getResAsync('bg_sound_mp3');
    bgChannel = bg.play();
    loading = false;
}

export enum SoundType {
    levelUp = 'levelUp',
    createEq = 'createEq',
    createCoins = 'createCoins',
    collectCoins = 'collectCoins',
    buttonSound = 'button_sound'
}



export const playSound = (type: string) => {
    if (!soundOn) return;
    const sound: egret.Sound = RES.getRes(type + "_mp3");
    if (sound)
        sound.play(0, 1);
    else
        RES.getResAsync(type + "_mp3")
}
