import { AjaxElementDataNew } from './../data/custom/ajaxElement/AjaxElementDataNew';
import { GetVisitInfoData } from './../data/pets/GetVisitInfoData';
import { GetSummerInfoData } from './../data/game/getInfo/GetSummerInfoData';
import { GetReviveCardNumData } from './../data/game/doRevive/GetReviveCardNumData';
import { DoReviveData } from './../data/game/doRevive/DoReviveData';
import { DoJoinPlugDrawData } from './../data/plug/doJoinPlugDraw/DoJoinPlugDrawData';
import { NetName } from './../enum/NetName';
import { QuestionSubmitData } from './../data/custom/questionSbumit/QuestionSubmitData';
import { GetCollectRuleData } from './../data/common/getCollectRule/GetCollectRuleData';
import { DatapashData } from './../data/game/datapash/DatapashData';
import { OpenCollectGoodsPrizeData } from './../data/common/openCollectGoodsPrize/openCollectGoodsPrizeData';
import { TwLang } from "../util/TwLang";
import { DoStartData } from "../data/game/doStart/DoStartData";
import { GetStartStatusData } from "../data/game/doStart/GetStartStatusData";
import { GetInfoData } from "../data/game/getInfo/GetInfoData";
import { GetOptionsData } from "../data/game/getOptions/GetOptionsData";
import { GetRuleData } from "../data/game/getRule/GetRuleData";
import { GetUserTotalScoreData } from "../data/game/getUserTotalScore/GetUserTotalScoreData";
import { GuessPokerData } from "../data/game/guessPoker/GuessPokerData";
import { GameSubmitData } from "../data/game/submit/GameSubmitData";
import { WinRanksData } from "../data/game/winranks/WinRanksData";
import { AjaxElementData } from "../data/custom/ajaxElement/AjaxElementData";
import { DoJoinData } from "../data/custom/doJoin/DoJoinData";
import { AjaxThroughInfoData } from "../data/custom/ajaxThroughInfo/AjaxThroughInfoData";
import { GetOrderInfoData } from "../data/custom/getOrderInfo/GetOrderInfoData";
import { GetCustomOrderStatusData } from "../data/custom/doJoin/GetCustomOrderStatusData";
import { GetRoleData } from "../data/common/getRole/GetRoleData";
import { GetCreditsData } from "../data/common/getCredits/GetCreditsData";
import { AddTimesForActivityData } from "../data/common/addTimesForActivity/AddTimesForActivityData";
import { SetRoleData } from "../data/common/setRole/SetRoleData";
import { GameGetSubmitResultData } from './../data/game/submit/GameGetSubmitResultData';
import { ThroughSubmitData } from '../data/custom/throughSubmit/ThroughSubmitData';
import { BeforSubmitData } from '../data/custom/beforSubmit/BeforSubmitData';
import { PetAdopteData } from "../data/pet/PetAdopteData";
import { PetFeedData } from "../data/pet/PetFeedData";
import { PetStatusData } from "../data/pet/PetStatusData";
import { SignInfoData } from "../data/pet/SignInfoData";
import { PetHomeInfoData } from "../data/pet/PetHomeInfoData";
import { GetToysData } from "../data/pet/GetToysData";
import { ToyExchangeData } from "../data/pet/ToyExchangeData";
import { ToyUseData } from "../data/pet/ToyUseData";
import { CollectData } from "../data/pet/CollectData";
import { Data } from '../data/Data';
import { GetPlugOrderStatusData } from '../data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { OptionInfoData } from '../data/plug/optionInfo/OptionInfoData';
import { UnblockingData } from '../data/plug/unblocking/UnblockingData';
import { GetPrizeInfoData } from '../data/plug/getPrizeInfo/GetPrizeInfoData';
// import { ABDataManager } from 'duiba-tc';
import { PetIndexData } from '../data/pet/PetIndexData';
// import { ICustomCfgData } from '..';
import { IGameCfgData } from '../data/game/cfg/IGameCfgData';
import { GetRankListData } from '../data/pet/GetRankListData';
import { GetFoodPilesData } from '../data/pet/GetFoodPilesData';
import { GetRecordData } from '../data/common/GetRecordData';
import { UseToyData } from '../data/pets/UseToyData';
import { GetActToysListData } from '../data/pets/GetActToysListData';
import { ToyExchangesData } from '../data/pets/ToyExchangesData';
import { GetUserToysListData } from '../data/pets/GetUserToysListData';
import { GetHomeInfoData } from '../data/pets/GetHomeInfoData';
import { PetsIndexData } from '../data/pets/PetsIndexData';
import { VisitStatisticsData } from '../data/pets/VisitStatisticsData';
import { VisitDetailData } from '../data/pets/VisitDetailData';
import { ABDataManager } from '../../tc/manager/ABDataManager';
import { ICustomCfgData } from '../data/custom/cfg/ICustomCfgData';
import { GetProfitDetailData } from '../data/customMade/GetProfitDetailData';
import { GooutData } from '../data/customMade/GooutData';
import { GooutRewardData } from '../data/customMade/GooutRewardData';
import { GetCollectGoodsInfoData } from '../data/common/getCollectGoodsInfo/GetCollectGoodsInfoData';
import { WeOrderData } from '../data/customMade/WeOrderData';
import { GooutResultData } from '../data/customMade/GooutResultData';
import { ToyExchangesDataXC } from '../data/pets/ToyExchangeDataXC';
import { ExchangeResultData } from '../data/pets/ExchangeResultData';

/**
 *Created by cuiliqiang on 2018/3/8
 * 数据管理
 */
export class DataManager extends ABDataManager {
    private static instance: DataManager;

    public static get ins(): DataManager {
        if (!this.instance) {
            this.instance = new DataManager();
        }
        return this.instance;
    }

    private isInit: boolean;
    constructor() {
        super();
        if (this.isInit) {
            throw Error(TwLang.lang_001);
        }
        this.isInit = true;
    }

    private _doJoinPlugDrawData: DoJoinPlugDrawData;
    private _getPlugOrderStatusData: GetPlugOrderStatusData;

    private _getRecordData:GetRecordData;

    private _gameInfoData:any;

    /**
     * 更新数据
     * @param {NetName} name
     * @param result
     * @returns {any}
     */
    // tslint:disable-next-line:cyclomatic-complexity
    public updateData(name: number, result: any, param?: any): Data {
        let data: Data;
        switch (name) {
            case NetName.PLUG_DO_JOIN:
                if (!this._doJoinPlugDrawData) {
                    this._doJoinPlugDrawData = new DoJoinPlugDrawData();
                }
                this._doJoinPlugDrawData.update(result);
                data = this._doJoinPlugDrawData;
                break;
            case NetName.PLUG_ORDER_STATUS:
                if (!this._getPlugOrderStatusData) {
                    this._getPlugOrderStatusData = new GetPlugOrderStatusData();
                }
                this._getPlugOrderStatusData.update(result);
                data = this._getPlugOrderStatusData;
                break;
            
            case NetName.GET_RECORD://查询我的奖品记录
                if(!this._getRecordData){
                    this._getRecordData = new GetRecordData();
                }
                this._getRecordData.update(result);
                data = this._getRecordData;



            default:
                this[this.getKey(name)]=result;
        }
        return data || result;
    }

    getData(name){
        return this[this.getKey(name)]
    }

    private getKey(name){
        return `_tw_data_${name}_`
    }

    /**
     * 插件
     */
    public get doJoinPlugDrawData(): DoJoinPlugDrawData {
        return this._doJoinPlugDrawData;
    }

    /**
     * 插件订单结果
     */
    public get getPlugOrderStatusData(): GetPlugOrderStatusData {
        return this._getPlugOrderStatusData;
    }

    /**
     * 查询我的奖品记录
     */
    public get getRecordData():GetRecordData{
        return this._getRecordData;
    }

    /**
     * 游戏主数据
     */
    public get getGameInfoData():any{
        return this._gameInfoData;
    }

    public set getGameInfoData(d:any){
        this._gameInfoData = d;
    }
    
}