
import Panel from "../views/Panel";

export default class RulePanel extends Panel {
    public maskRule: eui.Rect;
    public ruleLb: eui.Label;
    private mData: any;

    constructor(data?) {
        super(data);

        this.mData = data;
        this.percentHeight = 100;
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    private onLoad(): void {
        this.ruleLb.text = window['ruleText'] ? window['ruleText'] : `1、玩转拼图游戏需要使用66捞币/次\n2、第一关，在规定时间${window['gameTickNum'] ? window['gameTickNum'] : "N"}秒内完成九块拼图，将获得第二关拼图机会\n3、第二关，在规定时间${window['gameTickNum'] ? window['gameTickNum'] : "N"}秒内完成十六块拼图，将获得抽奖机会。`;
    }

    public initEvents(): void {
        super.initEvents();
    }

    public removeEvents(): void {
        super.removeEvents();
    }

    onTouchTap(): any {
        super.onTouchTap();

        if (this.mData && this.mData.callback) {
            this.mData.callback();
        }
    }

    public get skinKey() { return 'Rule' }
    // public get groupName() { return 'rule_panel'}
}