import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
export default class PrizePanel extends Panel {
    public prizeImg:eui.Image;
    public iknowBtn:eui.Button;
    public prizeNameLb:eui.Label;

    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel'}

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private async onLoad(){
        var url:string          = DataManager.ins.gameGetSubmitResultData.lottery.img;
        this.prizeNameLb.text   = DataManager.ins.gameGetSubmitResultData.lottery.name;
        this.prizeImg.source    = url;
    }

    private onTap():void{
        this.hidePanel();
        //获取游戏信息
        Loading.instace.show();
        NetManager.ins.getInfo((success:boolean) => {
            if(success){
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
            }else{
                //提示用户，返回上一层，重新进入活动？？？？？
                this.showMsg('iknowBtn', 
                [
                    {text: "网络开小差了\n世界上最遥远的距离莫过于此"}
                ]);
            }
            Loading.instace.hide();
        });
    }

    onTouchTap():any{
        super.onTouchTap();
        this.onTap();
    }

    //消息弹出框
	private showMsg(bname:string, msgArr:any, callBack?:Function, closeCallBack?:Function):void{
        var msgData:any = {
            btnName:bname, 
            fontSize:35, 
            lineCount:2, 
            lineSpace:15, 
            callBack:callBack ? callBack.bind(this) : null,
            closeCallBack:closeCallBack ? closeCallBack.bind(this) : null
        };
        msgData.msgArr = msgArr;

        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData);
    }
}